<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Cliente;

class ClienteController extends Controller
{
    
    
    
    
        public function buscarDNI(Request $request)
        {
            $dni = $request->dni;
            $apiUrl = "https://api.apis.net.pe/v1/dni?numero=" . $dni;
    
            try {
                $response = Http::get($apiUrl);
                $data = $response->json();
    
                if ($response->successful() && isset($data['nombre'])) {
                    return response()->json([
                        'success' => true,
                        'nombre' => $data['nombre']
                    ]);
                } else {
                    return response()->json([
                        'success' => false,
                        'message' => 'DNI no encontrado'
                    ]);
                }
            } catch (\Exception $e) {
                return response()->json([
                    'success' => false,
                    'message' => 'No se pudo conectar con la API'
                ]);
            }
        }
    }
    

