<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Cobro extends Model
{
    use HasFactory;

    protected $fillable = ['alquiler_id', 'monto', 'vuelto', 'fecha_cobro',];

    // ✅ Definir la relación con Alquiler
    public function alquiler()
    {
        return $this->belongsTo(Alquiler::class, 'alquiler_id');
    }
    public function productos()
{
    return $this->belongsToMany(Producto::class, 'cobro_producto')->withPivot('cantidad');
}
}
