<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Producto extends Model
{
    use HasFactory;

    protected $table = 'productos';

    protected $fillable = ['nombre', 'precio', 'stock', 'estado', 'imagen'];

    /**
     * Relación muchos a muchos con alquileres
     */
    public function alquileres()
    {
        return $this->belongsToMany(Alquiler::class, 'alquiler_producto')
                    ->withPivot('cantidad')
                    ->withTimestamps();
    }

    /**
     * Relación muchos a muchos con cobros
     */
    public function cobros()
    {
        return $this->belongsToMany(Cobro::class, 'cobro_producto')
                    ->withPivot('cantidad')
                    ->withTimestamps();
    }

    /**
     * Relación uno a muchos con VentaDetalle
     */
    public function detallesVenta()
    {
        return $this->hasMany(VentaDetalle::class, 'producto_id');
    }

    
}
