<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up()
    {
        Schema::create('alquiler_producto', function (Blueprint $table) {
            $table->id();
            // Aquí agregamos las claves foráneas con los nombres de las tablas explicítamente
            $table->bigInteger('alquiler_id')->unsigned();
$table->bigInteger('producto_id')->unsigned();
            $table->integer('cantidad');
            $table->decimal('precio_unitario', 8, 2);
            $table->decimal('total', 8, 2);
            $table->timestamps();
        });
    }
    

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('alquiler_producto');
    }
};
