@extends('adminlte::page')

@section('title', 'Editar Alquiler')

<head>
    <link rel="icon" href="{{ asset('icons/servicio.png') }}" type="image/x-icon">
    <link href="https://cdn.jsdelivr.net/npm/select2@4.0.13/dist/css/select2.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-datetimepicker/4.17.47/css/bootstrap-datetimepicker.min.css">
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <style>
        :root {
            --primary: #6C63FF;
            --secondary: #4D44DB;
            --accent: #FF6584;
            --success: #4CC9F0;
            --warning: #F8961E;
            --light: #F8F9FA;
            --dark: #212529;
            --gradient-primary: linear-gradient(135deg, var(--primary) 0%, var(--secondary) 100%);
            --gradient-accent: linear-gradient(135deg, var(--accent) 0%, #FF8E9E 100%);
        }
        
        body {
            font-family: 'Poppins', sans-serif;
            background-color: #F5F7FF;
        }
        
        .card {
            border: none;
            border-radius: 16px;
            box-shadow: 0 10px 30px rgba(108, 99, 255, 0.15);
            overflow: hidden;
            transition: transform 0.3s ease, box-shadow 0.3s ease;
            background: white;
        }
        
        .card:hover {
            transform: translateY(-5px);
            box-shadow: 0 15px 35px rgba(108, 99, 255, 0.2);
        }
        
        .card-header {
            background: var(--gradient-primary);
            border-bottom: none;
            padding: 1.5rem 2rem;
            position: relative;
            overflow: hidden;
        }
        
        .card-header::before {
            content: '';
            position: absolute;
            top: -50%;
            right: -50%;
            width: 200%;
            height: 200%;
            background: radial-gradient(circle, rgba(255,255,255,0.2) 0%, rgba(255,255,255,0) 70%);
            transform: rotate(30deg);
        }
        
        .card-header h3 {
            font-weight: 600;
            letter-spacing: 0.5px;
            position: relative;
            color: white;
            text-shadow: 0 2px 4px rgba(0,0,0,0.1);
        }
        
        .card-body {
            padding: 2.5rem;
            background: white;
        }
        
        .form-control, .input-group-text, .select2-container--default .select2-selection--single {
            border-radius: 12px;
            border: 2px solid #E9ECF5;
            padding: 0.8rem 1.2rem;
            height: auto;
            font-size: 0.95rem;
            transition: all 0.3s ease;
            background-color: #F8FAFF;
        }
        
        .form-control:focus, .select2-container--default.select2-container--focus .select2-selection--single {
            box-shadow: 0 0 0 4px rgba(108, 99, 255, 0.15);
            border-color: var(--primary);
            background-color: white;
        }
        
        .input-group-text {
            background-color: var(--primary);
            color: white;
            border: 2px solid var(--primary);
            font-size: 1rem;
        }
        
        .btn {
            border-radius: 12px;
            padding: 0.7rem 1.8rem;
            font-weight: 500;
            letter-spacing: 0.5px;
            transition: all 0.3s ease;
            position: relative;
            overflow: hidden;
            border: none;
            font-size: 0.95rem;
        }
        
        .btn::after {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background: linear-gradient(rgba(255,255,255,0.2), rgba(255,255,255,0));
            opacity: 0;
            transition: opacity 0.3s ease;
        }
        
        .btn:hover::after {
            opacity: 1;
        }
        
        .btn-primary {
            background: var(--gradient-primary);
            box-shadow: 0 4px 15px rgba(108, 99, 255, 0.3);
        }
        
        .btn-primary:hover {
            transform: translateY(-3px);
            box-shadow: 0 8px 25px rgba(108, 99, 255, 0.4);
        }
        
        .btn-outline-danger {
            border: 2px solid var(--accent);
            color: var(--accent);
            background-color: transparent;
        }
        
        .btn-outline-danger:hover {
            background: var(--gradient-accent);
            color: white;
            border-color: transparent;
            box-shadow: 0 4px 15px rgba(255, 101, 132, 0.3);
        }
        
        label.font-weight-bold {
            color: #4A5568;
            font-size: 0.95rem;
            margin-bottom: 0.7rem;
            font-weight: 600 !important;
            display: flex;
            align-items: center;
        }
        
        .form-group {
            margin-bottom: 2rem;
            position: relative;
        }
        
        .form-group.focused label {
            color: var(--primary);
        }
        
        .alert {
            border-radius: 12px;
            border: none;
            box-shadow: 0 4px 12px rgba(0,0,0,0.05);
        }
        
        .alert-danger {
            background-color: #FFF5F7;
            color: #E53E3E;
            border-left: 4px solid var(--accent);
        }
        
        .card-footer {
            background-color: transparent;
            border-top: 1px solid #EDF2F7;
            padding: 1.5rem 2.5rem;
            display: flex;
            justify-content: space-between;
        }
        
        /* Select2 custom styles */
        .select2-container--default .select2-selection--single {
            height: calc(1.5em + 1.6rem + 4px) !important;
        }
        
        .select2-container--default .select2-selection--single .select2-selection__rendered {
            line-height: calc(1.5em + 1.6rem) !important;
            color: #4A5568;
        }
        
        .select2-container--default .select2-selection--single .select2-selection__arrow {
            height: calc(1.5em + 1.6rem + 4px) !important;
        }
        
        /* Floating animation */
        @keyframes float {
            0% { transform: translateY(0px); }
            50% { transform: translateY(-10px); }
            100% { transform: translateY(0px); }
        }
        
        .floating-icon {
            animation: float 3s ease-in-out infinite;
            display: inline-block;
        }
        
        /* Pulse effect */
        @keyframes pulse {
            0% { box-shadow: 0 0 0 0 rgba(108, 99, 255, 0.4); }
            70% { box-shadow: 0 0 0 10px rgba(108, 99, 255, 0); }
            100% { box-shadow: 0 0 0 0 rgba(108, 99, 255, 0); }
        }
        
        .pulse {
            animation: pulse 2s infinite;
            border-radius: 50%;
        }
        
        /* Custom checkbox */
        .custom-control-input:checked~.custom-control-label::before {
            background: var(--gradient-primary);
            border-color: var(--primary);
        }
        
        /* Responsive adjustments */
        @media (max-width: 768px) {
            .card-body {
                padding: 1.5rem;
            }
            
            .card-footer {
                flex-direction: column;
                gap: 1rem;
            }
            
            .btn {
                width: 100%;
            }
        }
        
        /* Custom scrollbar */
        ::-webkit-scrollbar {
            width: 8px;
            height: 8px;
        }
        
        ::-webkit-scrollbar-track {
            background: #F1F1F1;
        }
        
        ::-webkit-scrollbar-thumb {
            background: var(--primary);
            border-radius: 10px;
        }
        
        /* Glow effect for inputs */
        .glow-on-hover:hover {
            box-shadow: 0 0 15px rgba(108, 99, 255, 0.3);
        }
    </style>
</head>

@section('content_header')
    <div class="d-flex justify-content-between align-items-center py-3">
        <h1 class="m-0 text-dark font-weight-bold" style="letter-spacing: 1px;">
            <i class="fas fa-film mr-2 text-primary"></i>Editar Alquiler
        </h1>
        <a href="{{ route('alquileres.index') }}" class="btn btn-outline-primary glow-on-hover">
            <i class="fas fa-arrow-left mr-2"></i> Volver al Listado
        </a>
    </div>
@stop

@section('content')
    <div class="container-fluid">
        <div class="row justify-content-center">
            <div class="col-lg-10">
                <div class="card">
                    <div class="card-header">
                        <h3 class="card-title mb-0 text-white">
                            <i class="fas fa-edit mr-2 floating-icon"></i>Formulario de Edición
                        </h3>
                    </div>
                    
                    <div class="card-body">
                        @if ($errors->any())
                            <div class="alert alert-danger alert-dismissible fade show mb-4">
                                <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                    <span aria-hidden="true">&times;</span>
                                </button>
                                <div class="d-flex align-items-center">
                                    <i class="fas fa-exclamation-triangle mr-2 text-accent"></i>
                                    <h5 class="mb-0 font-weight-bold">Error de Validación</h5>
                                </div>
                                <ul class="mt-2 mb-0 pl-3">
                                    @foreach ($errors->all() as $error)
                                        <li>{{ $error }}</li>
                                    @endforeach
                                </ul>
                            </div>
                        @endif

                        <form action="{{ route('alquileres.update', $alquiler->id ?? '') }}" method="POST" class="needs-validation" novalidate>
                            @csrf
                            @method('PUT')

                            <div class="row">
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="pelicula_id" class="font-weight-bold">
                                            <i class="fas fa-film mr-2 text-primary pulse" style="font-size: 1.1rem;"></i> Película
                                        </label>
                                        <select name="pelicula_id" id="pelicula_id" class="form-control select2 glow-on-hover" required style="width: 100%;">
                                            <option value="">Seleccione una película</option>
                                            @foreach($peliculas as $pelicula)
                                                <option value="{{ $pelicula->id }}" 
                                                    {{ old('pelicula_id', $alquiler->pelicula_id ?? '') == $pelicula->id ? 'selected' : '' }}>
                                                    {{ $pelicula->titulo }}
                                                </option>
                                            @endforeach
                                        </select>
                                        <div class="invalid-feedback">
                                            Por favor seleccione una película.
                                        </div>
                                    </div>
                                </div>

                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="cliente" class="font-weight-bold">
                                            <i class="fas fa-user-tie mr-2 text-primary pulse" style="font-size: 1.1rem;"></i> Cliente
                                        </label>
                                        <div class="input-group glow-on-hover">
                                            <div class="input-group-prepend">
                                                <span class="input-group-text bg-primary text-white">
                                                    <i class="fas fa-user"></i>
                                                </span>
                                            </div>
                                            <input type="text" name="cliente" id="cliente" class="form-control" required
                                                value="{{ old('cliente', $alquiler->cliente ?? '') }}" placeholder="Nombre del cliente">
                                            <div class="invalid-feedback">
                                                Por favor ingrese el nombre del cliente.
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="row">
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="hora_entrada" class="font-weight-bold">
                                            <i class="far fa-clock mr-2 text-primary pulse" style="font-size: 1.1rem;"></i> Hora de Entrada
                                        </label>
                                        <div class="input-group date glow-on-hover" id="horaEntradaPicker">
                                            <div class="input-group-prepend">
                                                <span class="input-group-text bg-primary text-white">
                                                    <i class="far fa-clock"></i>
                                                </span>
                                            </div>
                                            <input type="text" name="hora_entrada" class="form-control datetimepicker-input" 
                                                value="{{ old('hora_entrada', $alquiler->hora_entrada ?? '') }}" 
                                                data-toggle="datetimepicker" data-target="#horaEntradaPicker" placeholder="HH:MM"/>
                                        </div>
                                    </div>
                                </div>

                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="hora_salida" class="font-weight-bold">
                                            <i class="far fa-clock mr-2 text-primary pulse" style="font-size: 1.1rem;"></i> Hora de Salida
                                        </label>
                                        <div class="input-group date glow-on-hover" id="horaSalidaPicker">
                                            <div class="input-group-prepend">
                                                <span class="input-group-text bg-primary text-white">
                                                    <i class="far fa-clock"></i>
                                                </span>
                                            </div>
                                            <input type="text" name="hora_salida" class="form-control datetimepicker-input" 
                                                value="{{ old('hora_salida', $alquiler->hora_salida ?? '') }}" 
                                                data-toggle="datetimepicker" data-target="#horaSalidaPicker" placeholder="HH:MM"/>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="row">
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="precio" class="font-weight-bold">
                                            <i class="fas fa-dollar-sign mr-2 text-primary pulse" style="font-size: 1.1rem;"></i> Precio del Alquiler
                                        </label>
                                        <div class="input-group glow-on-hover">
                                            <div class="input-group-prepend">
                                                <span class="input-group-text bg-primary text-white">
                                                    S/
                                                </span>
                                            </div>
                                            <input type="number" step="0.01" class="form-control" id="precio" name="precio" required
                                                value="{{ old('precio', $alquiler->precio ?? '') }}" placeholder="0.00">
                                            <div class="invalid-feedback">
                                                Por favor ingrese un precio válido.
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="estado" class="font-weight-bold">
                                            <i class="fas fa-check-circle mr-2 text-primary pulse" style="font-size: 1.1rem;"></i> Estado
                                        </label>
                                        <select name="estado" id="estado" class="form-control select2 glow-on-hover" required>
                                            <option value="pendiente" {{ old('estado', $alquiler->estado ?? '') == 'pendiente' ? 'selected' : '' }}>Pendiente</option>
                                            <option value="completado" {{ old('estado', $alquiler->estado ?? '') == 'completado' ? 'selected' : '' }}>Completado</option>
                                            <option value="cancelado" {{ old('estado', $alquiler->estado ?? '') == 'cancelado' ? 'selected' : '' }}>Cancelado</option>
                                        </select>
                                    </div>
                                </div>
                            </div>

                            <div class="card-footer px-0">
                                <button type="reset" class="btn btn-outline-danger glow-on-hover">
                                    <i class="fas fa-undo mr-1"></i> Limpiar Formulario
                                </button>
                                <button type="submit" class="btn btn-primary glow-on-hover">
                                    <i class="fas fa-save mr-1"></i> Guardar Cambios
                                </button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@section('js')
    <script src="https://cdn.jsdelivr.net/npm/select2@4.0.13/dist/js/select2.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/moment.js/2.29.1/moment.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-datetimepicker/4.17.47/js/bootstrap-datetimepicker.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    
    <script>
        $(document).ready(function() {
            // Initialize Select2 with modern styling
            $('.select2').select2({
                placeholder: "Seleccione una opción",
                allowClear: true,
                theme: 'bootstrap4',
                width: '100%',
                dropdownParent: $('.card-body')
            }).on('select2:open', function() {
                $('.select2-search__field').attr('placeholder', 'Buscar...');
            });

            // Modern datetime picker with icons
            $('#horaEntradaPicker, #horaSalidaPicker').datetimepicker({
                format: 'HH:mm',
                stepping: 15,
                useCurrent: false,
                icons: {
                    time: 'far fa-clock',
                    up: 'fas fa-chevron-up',
                    down: 'fas fa-chevron-down',
                    previous: 'fas fa-chevron-left',
                    next: 'fas fa-chevron-right',
                    today: 'fas fa-calendar-check',
                    clear: 'fas fa-trash',
                    close: 'fas fa-times'
                },
                widgetPositioning: {
                    horizontal: 'left',
                    vertical: 'bottom'
                }
            });

            // Form validation with modern feedback
            (function() {
                'use strict';
                window.addEventListener('load', function() {
                    var forms = document.getElementsByClassName('needs-validation');
                    var validation = Array.prototype.filter.call(forms, function(form) {
                        form.addEventListener('submit', function(event) {
                            if (form.checkValidity() === false) {
                                event.preventDefault();
                                event.stopPropagation();
                                
                                // Animate invalid fields
                                $('.is-invalid').each(function() {
                                    $(this).addClass('animate__animated animate__shakeX');
                                    setTimeout(() => {
                                        $(this).removeClass('animate__animated animate__shakeX');
                                    }, 1000);
                                });
                            }
                            form.classList.add('was-validated');
                        }, false);
                    });
                }, false);
            })();

            // Enhanced success message with animation
            @if(session('success'))
                Swal.fire({
                    title: '¡Éxito!',
                    text: '{{ session('success') }}',
                    icon: 'success',
                    showConfirmButton: false,
                    timer: 3000,
                    background: 'white',
                    backdrop: `
                        rgba(108,99,255,0.4)
                        url("/images/nyan-cat.gif")
                        center top
                        no-repeat
                    `,
                    customClass: {
                        popup: 'animate__animated animate__zoomIn'
                    }
                });
            @endif
            
            // Input focus effects
            $('.form-control').on('focus', function() {
                $(this).closest('.form-group').addClass('focused');
                $(this).parent('.input-group').addClass('input-group-focus');
            }).on('blur', function() {
                $(this).closest('.form-group').removeClass('focused');
                $(this).parent('.input-group').removeClass('input-group-focus');
            });
            
            // Add glow effect on hover
            $('.glow-on-hover').hover(
                function() {
                    $(this).css('box-shadow', '0 0 15px rgba(108, 99, 255, 0.3)');
                },
                function() {
                    $(this).css('box-shadow', 'none');
                }
            );
            
            // Auto-format price input
            $('#precio').on('blur', function() {
                let value = parseFloat($(this).val()).toFixed(2);
                if (!isNaN(value)) {
                    $(this).val(value);
                }
            });
            
            // Add animation to icons on hover
            $('.pulse').hover(
                function() {
                    $(this).addClass('animate__animated animate__pulse');
                },
                function() {
                    $(this).removeClass('animate__animated animate__pulse');
                }
            );
        });
    </script>
@endsection