@extends('adminlte::page')
@section('title', 'Servicio')

<head>
    <link rel="icon" href="{{ asset('icons/servicio.png') }}" type="image/x-icon">
    <!-- Font Awesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <!-- Bootstrap Icons -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.0/font/bootstrap-icons.css">
</head>

@section('content_header')
<div class="container-fluid">
    <div class="row mb-2">
        <div class="col-sm-6">
            <h1 class="m-0 text-dark"><i class="fas fa-film mr-2"></i>Gestión de Alquileres</h1>
        </div>
        <div class="col-sm-6">
            <div class="float-sm-right">
                @can('crear peliculas')
                <div class="btn-group" role="group">
                    <!-- Botón para Excel -->
                    <a href="{{ route('alquiler.export-excel') }}" class="btn btn-success btn-sm" title="Exportar a Excel">
                        <i class="fas fa-file-excel mr-1"></i> Excel
                    </a>
                    <!-- Botón para PDF -->
                    <a href="" class="btn btn-danger btn-sm ml-2" target="_blank" title="Descargar PDF">
                        <i class="fas fa-file-pdf mr-1"></i> PDF
                    </a>
                </div>
                @endcan
            </div>
        </div>
    </div>
</div>
@stop

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card card-primary card-outline shadow">
                <div class="card-header bg-gradient-light">
                    <div class="d-flex justify-content-between align-items-center">
                        <div>
                            <h4 class="card-title mb-0"><i class="fas fa-ticket-alt mr-2"></i>Listado de Alquileres</h4>
                        </div>
                        <div>
                            <a href="{{ route('ventas.crear') }}" class="btn btn-success me-2">
                                <i class="fas fa-shopping-cart mr-1"></i> Vender
                            </a>
                            <a href="{{ route('alquileres.create') }}" class="btn btn-primary">
                                <i class="fas fa-plus-circle mr-1"></i> Nuevo Alquiler
                            </a>
                        </div>
                    </div>
                </div>
                
                <div class="card-body p-0">
                    <div class="table-responsive">
                        <table class="table table-hover table-striped text-center">
                            <thead class="thead-dark">
                                <tr>
                                    <th class="align-middle">ID</th>
                                    <th class="align-middle">Película</th>
                                    <th class="align-middle">Cliente</th>
                                    <th class="align-middle">Sala</th>
                                    <th class="align-middle">Horario</th>
                                    <th class="align-middle">Precio</th>
                                    <th class="align-middle">Estado</th>
                                    <th class="align-middle">Acciones</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach ($alquileres as $alquiler)
                                    <tr>
                                        <td class="align-middle">{{ $alquiler->id }}</td>
                                        <td class="align-middle">
                                            <div class="d-flex align-items-center justify-content-center">
                                                @if($alquiler->pelicula->imagen)
                                                    <img src="{{ asset('storage/' . $alquiler->pelicula->imagen) }}" 
                                                         alt="{{ $alquiler->pelicula->titulo }}" 
                                                         class="img-thumbnail rounded-circle mr-2" 
                                                         style="width: 40px; height: 40px; object-fit: cover;">
                                                @endif
                                                <span>{{ $alquiler->pelicula->titulo ?? 'Sin título' }}</span>
                                            </div>
                                        </td>
                                        <td class="align-middle">{{ $alquiler->cliente }}</td>
                                        <td class="align-middle">
                                            @if ($alquiler->sala)
                                                <span class="badge {{ $alquiler->sala->tipo === 'VIP' ? 'bg-warning' : 'bg-primary' }}">
                                                    {!! $alquiler->sala->tipo === 'VIP' ? '<i class="fas fa-crown"></i> VIP' : '<i class="fas fa-chair"></i> NORMAL' !!}
                                                </span>
                                                <strong>{{ $alquiler->sala->nombre }}</strong>
                                            @else
                                                <span class="text-muted">Sin sala</span>
                                            @endif
                                        </td>
                                        <td class="align-middle">
                                            <small class="d-block"><strong>Entrada:</strong> {{ $alquiler->hora_entrada }}</small>
                                            <small class="d-block"><strong>Salida:</strong> {{ $alquiler->hora_salida }}</small>
                                        </td>
                                        <td class="align-middle">
                                            <span class="badge bg-success">
                                                S/{{ number_format($alquiler->precio, 2) }}
                                            </span>
                                        </td>
                                        <td class="align-middle">
                                            @if ($alquiler->estado === 'pagado')
                                                <span class="badge badge-success p-2">
                                                    <i class="fas fa-check-circle mr-1"></i> Pagado
                                                </span>
                                            @else
                                                <span class="badge badge-warning p-2">
                                                    <i class="fas fa-exclamation-circle mr-1"></i> Pendiente
                                                </span>
                                            @endif
                                        </td>
                                        <td class="align-middle">
                                            <div class="btn-group btn-group-sm" role="group">
                                                <a href="{{ route('alquileres.show', $alquiler) }}" 
                                                   class="btn btn-info" 
                                                   data-toggle="tooltip" 
                                                   title="Ver detalles">
                                                    <i class="fas fa-eye"></i>
                                                </a>
                                                @can('crear peliculas')
                                                <a href="{{ route('alquileres.edit', $alquiler) }}" 
                                                   class="btn btn-warning" 
                                                   data-toggle="tooltip" 
                                                   title="Editar">
                                                    <i class="fas fa-edit"></i>
                                                </a>
                                                <button class="btn btn-danger" 
                                                        onclick="eliminarAlquiler({{ $alquiler->id }})"
                                                        data-toggle="tooltip" 
                                                        title="Eliminar">
                                                    <i class="fas fa-trash"></i>
                                                </button>
                                                @endcan
                                                <!-- Mostrar botón de cobrar solo si está pendiente -->
                                                @if($alquiler->estado !== 'pagado')
                                                    <button class="btn btn-success" 
                                                            onclick="abrirModalCobro({{ $alquiler->id }}, {{ $alquiler->precio }}, '{{ $alquiler->cliente }}', '{{ $alquiler->pelicula->titulo ?? 'Sin título' }}', '{{ $alquiler->hora_entrada }}', '{{ $alquiler->hora_salida }}', '{{ $alquiler->estado }}')"
                                                            data-toggle="tooltip" 
                                                            title="Cobrar">
                                                        <i class="fas fa-cash-register"></i>
                                                    </button>
                                                @endif
                                                <button class="btn btn-secondary" 
                                                   onclick="abrirModalTicket({{ $alquiler->id }}, '{{ $alquiler->cliente }}', '{{ $alquiler->pelicula->titulo ?? 'Sin título' }}', {{ $alquiler->precio }}, '{{ $alquiler->hora_entrada }}', '{{ $alquiler->hora_salida }}', '{{ $alquiler->estado }}', '{{ $alquiler->sala->nombre ?? 'Sin sala' }}')"
                                                   data-toggle="tooltip" 
                                                   title="Ver ticket">
                                                    <i class="fas fa-receipt"></i>
                                                </button>
                                            </div>
                                        </td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>

                <div class="card-footer clearfix">
                    <div class="float-right">
                        {{ $alquileres->links('pagination::bootstrap-4') }}
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Modal de Cobro Mejorado -->
<div class="modal fade" id="modalCobro" tabindex="-1" role="dialog" aria-labelledby="modalCobroLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered modal-lg" role="document">
        <div class="modal-content border-0 shadow-lg">
            <!-- Encabezado con gradiente -->
            <div class="modal-header bg-gradient-primary text-white">
                <h5 class="modal-title" id="modalCobroLabel">
                    <i class="fas fa-cash-register mr-2"></i>Procesar Pago
                </h5>
                <button type="button" class="close text-white" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            
            <!-- Cuerpo del modal -->
            <div class="modal-body p-4">
                <input type="hidden" id="alquiler_id">
                
                <div class="row">
                    <!-- Columna izquierda - Formulario de pago -->
                    <div class="col-md-7">
                        <div class="form-group mb-4">
                            <label class="font-weight-bold text-primary mb-2">Total a pagar:</label>
                            <div class="input-group input-group-lg">
                                <div class="input-group-prepend">
                                    <span class="input-group-text bg-success text-white py-3">
                                        <i class="fas fa-dollar-sign fa-lg"></i>
                                    </span>
                                </div>
                                <input type="text" id="precio" class="form-control form-control-lg font-weight-bold border-left-0 bg-light" readonly style="font-size: 1.25rem;">
                            </div>
                        </div>

                        <div class="form-group mb-4">
                            <label class="font-weight-bold text-primary mb-2">Método de Pago:</label>
                            <div class="btn-group btn-group-toggle w-100" data-toggle="buttons">
                                <label class="btn btn-outline-primary active px-4 py-3">
                                    <input type="radio" name="metodo_pago" id="option1" value="efectivo" checked onclick="mostrarOpcionesPago('efectivo')"> 
                                    <i class="fas fa-money-bill-wave mr-2"></i>Efectivo
                                </label>
                                <label class="btn btn-outline-primary px-4 py-3">
                                    <input type="radio" name="metodo_pago" id="option2" value="yape" onclick="mostrarOpcionesPago('yape')"> 
                                    <i class="fas fa-mobile-alt mr-2"></i>Yape
                                </label>
                                <label class="btn btn-outline-primary px-4 py-3">
                                    <input type="radio" name="metodo_pago" id="option3" value="tarjeta" onclick="mostrarOpcionesPago('tarjeta')"> 
                                    <i class="fas fa-credit-card mr-2"></i>Tarjeta
                                </label>
                            </div>
                        </div>

                        <!-- Opciones para efectivo -->
                        <div id="pagoEfectivo" class="metodo-pago-content">
                            <div class="form-group mb-4">
                                <label class="font-weight-bold mb-2">Monto Recibido:</label>
                                <div class="input-group input-group-lg">
                                    <div class="input-group-prepend">
                                        <span class="input-group-text bg-primary text-white py-3">
                                            <i class="fas fa-money-bill-wave fa-lg"></i>
                                        </span>
                                    </div>
                                    <input type="number" id="monto_pagado" name="monto_pagado" class="form-control form-control-lg" placeholder="0.00">
                                </div>
                            </div>
                            <div class="alert alert-success py-3">
                                <div class="d-flex justify-content-between align-items-center">
                                    <strong class="text-primary">Cambio:</strong>
                                    <span id="vuelto" class="font-weight-bold" style="font-size: 1.25rem;">S/0.00</span>
                                </div>
                            </div>
                            
                            <!-- Botones de ayuda para efectivo -->
                            <div class="d-flex flex-wrap justify-content-between mt-3">
                                <button type="button" class="btn btn-outline-secondary m-1" onclick="setMonto(10)">S/10</button>
                                <button type="button" class="btn btn-outline-secondary m-1" onclick="setMonto(20)">S/20</button>
                                <button type="button" class="btn btn-outline-secondary m-1" onclick="setMonto(50)">S/50</button>
                                <button type="button" class="btn btn-outline-secondary m-1" onclick="setMonto(100)">S/100</button>
                                <button type="button" class="btn btn-outline-secondary m-1" onclick="setMontoExacto()">Monto Exacto</button>
                            </div>
                        </div>
                        
                        <!-- Opciones para Yape -->
                        <div id="pagoYape" class="metodo-pago-content" style="display: none;">
                            <div class="card border-0 shadow-sm mb-4">
                                <div class="card-header bg-light">
                                    <h6 class="mb-0 font-weight-bold"><i class="fas fa-qrcode mr-2"></i>Pago con Yape</h6>
                                </div>
                                <div class="card-body d-flex flex-column align-items-center justify-content-center py-4">
                                    <div class="text-center mb-3">
                                        <img src="/imagenes/yape.jpg" alt="QR de Yape" class="img-fluid rounded shadow" style="max-width: 220px; border: 1px solid #eee;">
                                    </div>
                                    <div class="alert alert-info w-100 mb-0">
                                        <i class="fas fa-info-circle mr-2"></i> Escanea el código para realizar el pago
                                    </div>
                                </div>
                            </div>
                        </div>
                        
                        <!-- Opciones para Tarjeta -->
                        <div id="pagoTarjeta" class="metodo-pago-content" style="display: none;">
                            <div class="card border-0 shadow-sm mb-4">
                                <div class="card-header bg-light">
                                    <h6 class="mb-0 font-weight-bold"><i class="fas fa-credit-card mr-2"></i>Pago con Tarjeta</h6>
                                </div>
                                <div class="card-body py-4">
                                    <div class="form-group">
                                        <label>Número de Tarjeta</label>
                                        <div class="input-group">
                                            <div class="input-group-prepend">
                                                <span class="input-group-text"><i class="fas fa-credit-card"></i></span>
                                            </div>
                                            <input type="text" class="form-control" placeholder="XXXX XXXX XXXX XXXX">
                                        </div>
                                    </div>
                                    <div class="row">
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label>Fecha de Expiración</label>
                                                <input type="text" class="form-control" placeholder="MM/AA">
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label>CVV</label>
                                                <input type="text" class="form-control" placeholder="XXX">
                                            </div>
                                        </div>
                                    </div>
                                    <div class="form-group mb-0">
                                        <label>Nombre del Titular</label>
                                        <input type="text" class="form-control" placeholder="Como aparece en la tarjeta">
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <!-- Columna derecha - Resumen -->
                    <div class="col-md-5">
                        <div class="card border-0 shadow-sm h-100">
                            <div class="card-header bg-light">
                                <h6 class="mb-0 font-weight-bold"><i class="fas fa-receipt mr-2"></i>Resumen del Alquiler</h6>
                            </div>
                            <div class="card-body">
                                <ul class="list-group list-group-flush">
                                    <li class="list-group-item d-flex justify-content-between align-items-center px-0 py-2">
                                        <span class="text-muted">ID Alquiler:</span>
                                        <span class="font-weight-bold" id="resumenId"></span>
                                    </li>
                                    <li class="list-group-item d-flex justify-content-between align-items-center px-0 py-2">
                                        <span class="text-muted">Película:</span>
                                        <span class="font-weight-bold text-right" id="resumenPelicula"></span>
                                    </li>
                                    <li class="list-group-item d-flex justify-content-between align-items-center px-0 py-2">
                                        <span class="text-muted">Cliente:</span>
                                        <span class="font-weight-bold text-right" id="resumenCliente"></span>
                                    </li>
                                    <li class="list-group-item d-flex justify-content-between align-items-center px-0 py-2">
                                        <span class="text-muted">Precio:</span>
                                        <span class="font-weight-bold text-success" id="resumenPrecio"></span>
                                    </li>
                                    <li class="list-group-item d-flex justify-content-between align-items-center px-0 py-2">
                                        <span class="text-muted">Hora de Entrada:</span>
                                        <span class="font-weight-bold text-right" id="resumenHoraEntrada"></span>
                                    </li>
                                    <li class="list-group-item d-flex justify-content-between align-items-center px-0 py-2">
                                        <span class="text-muted">Hora de Salida:</span>
                                        <span class="font-weight-bold text-right" id="resumenHoraSalida"></span>
                                    </li>
                                    <li class="list-group-item d-flex justify-content-between align-items-center px-0 py-2">
                                        <span class="text-muted">Estado:</span>
                                        <span class="badge badge-pill badge-warning px-3 py-2" id="resumenEstado"></span>
                                    </li>
                                </ul>
                            </div>
                            <div class="card-footer bg-light">
                                <small class="text-muted"><i class="fas fa-info-circle mr-1"></i> Se generará un ticket automáticamente después del pago.</small>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            
            <!-- Pie del modal -->
            <div class="modal-footer bg-light">
                <button type="button" class="btn btn-outline-secondary px-4" data-dismiss="modal">
                    <i class="fas fa-times mr-2"></i> Cancelar
                </button>
                <button type="button" class="btn btn-primary px-4" onclick="procesarCobro()">
                    <i class="fas fa-check-circle mr-2"></i> Confirmar Pago
                </button>
            </div>
        </div>
    </div>
</div>

<!-- Modal de Ticket -->
<div class="modal fade" id="modalTicket" tabindex="-1" role="dialog" aria-labelledby="modalTicketLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered" role="document">
        <div class="modal-content border-0 shadow-lg">
            <!-- Encabezado con gradiente -->
            <div class="modal-header bg-gradient-secondary text-white">
                <h5 class="modal-title" id="modalTicketLabel">
                    <i class="fas fa-receipt mr-2"></i>Ticket de Alquiler
                </h5>
                <button type="button" class="close text-white" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            
            <!-- Cuerpo del modal - Ticket -->
            <div class="modal-body p-0">
                <div id="ticket-container" class="bg-white p-4" style="font-family: 'Courier New', monospace;">
                    <!-- Encabezado de Ticket -->
                    <div class="text-center mb-4">
                        <h4 class="mb-1" style="font-weight: 700;">CINESTACION</h4>
                        <p class="mb-1" style="font-size: 14px;">Av. Principal</p>
                        <p class="mb-1" style="font-size: 14px;">RUC: 123456789</p>
                        <p class="mb-1" style="font-size: 14px;">TELEFONO: 123456789</p>
                        <hr style="border-style: dashed;">
                        <h5 class="mb-0">TICKET DE ALQUILER</h5>
                        <p class="mb-0" id="ticket-fecha" style="font-size: 14px;"></p>
                    </div>
                    
                    <!-- Contenido del Ticket -->
                    <div class="mb-3">
                        <div class="row mb-2">
                            <div class="col-5 text-left">Ticket Nº:</div>
                            <div class="col-7 text-right" id="ticket-id"></div>
                        </div>
                        <div class="row mb-2">
                            <div class="col-5 text-left">Cliente:</div>
                            <div class="col-7 text-right" id="ticket-cliente"></div>
                        </div>
                        <div class="row mb-2">
                            <div class="col-5 text-left">Película:</div>
                            <div class="col-7 text-right" id="ticket-pelicula"></div>
                        </div>
                        <div class="row mb-2">
                            <div class="col-5 text-left">Sala:</div>
                            <div class="col-7 text-right" id="ticket-sala"></div>
                        </div>
                        <div class="row mb-2">
                            <div class="col-5 text-left">Hora Entrada:</div>
                            <div class="col-7 text-right" id="ticket-hora-entrada"></div>
                        </div>
                        <div class="row mb-2">
                            <div class="col-5 text-left">Hora Salida:</div>
                            <div class="col-7 text-right" id="ticket-hora-salida"></div>
                        </div>
                        <hr style="border-style: dashed;">
                        <div class="row mb-2">
                            <div class="col-5 text-left"><strong>TOTAL:</strong></div>
                            <div class="col-7 text-right"><strong id="ticket-precio"></strong></div>
                        </div>
                        <div class="row mb-2">
                            <div class="col-5 text-left">Estado:</div>
                            <div class="col-7 text-right" id="ticket-estado"></div>
                        </div>
                    </div>
                    
                    <!-- Pie de Ticket -->
                    <div class="text-center mt-4">
                        <hr style="border-style: dashed;">
                        <p class="mb-1" style="font-size: 14px;">¡Gracias por su preferencia!</p>
                        <p style="font-size: 14px;">Vuelva pronto</p>
                        
                        <!-- Código QR (simulado con un div) -->
                        <div class="d-flex justify-content-center mt-3">
                            <div style="width: 100px; height: 100px; background-color: #f5f5f5; border: 1px solid #ddd; display: flex; align-items: center; justify-content: center;">
                                <i class="fas fa-qrcode fa-3x text-muted"></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            
            <!-- Pie del modal -->
            <div class="modal-footer bg-light">
                <button type="button" class="btn btn-outline-secondary px-3" data-dismiss="modal">
                    <i class="fas fa-times mr-2"></i> Cerrar
                </button>
                <button type="button" class="btn btn-info px-3" onclick="imprimirTicket()">
                    <i class="fas fa-print mr-2"></i> Imprimir
                </button>
                <a id="downloadTicket" href="{{ route('ticket.pdf', '') }}" class="btn btn-primary px-3" target="_blank">
                    <i class="fas fa-file-download mr-2"></i> Descargar PDF
                </a>
            </div>
        </div>
    </div>
</div>

@section('footer')
<div class="float-right d-none d-sm-block">
    
</div>

@stop

<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script>
    $(function () {
        $('[data-toggle="tooltip"]').tooltip();
    });

    function abrirModalCobro(id, precio, cliente, pelicula, horaEntrada, horaSalida, estado) {
        // Llenar información del alquiler
        document.getElementById('alquiler_id').value = id;
        document.getElementById('precio').value = 'S/' + precio.toFixed(2);
        document.getElementById('monto_pagado').value = '';
        document.getElementById('vuelto').textContent = 'S/0.00';
        
        // Cargar datos en el resumen
        document.getElementById('resumenId').textContent = id;
        document.getElementById('resumenPelicula').textContent = pelicula;
        document.getElementById('resumenCliente').textContent = cliente;
        document.getElementById('resumenPrecio').textContent = 'S/' + precio.toFixed(2);
        document.getElementById('resumenHoraEntrada').textContent = horaEntrada;
        document.getElementById('resumenHoraSalida').textContent = horaSalida;
        document.getElementById('resumenEstado').textContent = estado;
        
        // Configurar vista por defecto
        mostrarOpcionesPago('efectivo');
        
        $('#modalCobro').modal('show');
    }

    function mostrarOpcionesPago(metodo) {
        // Ocultar todos los métodos
        document.querySelectorAll('.metodo-pago-content').forEach(div => {
            div.style.display = 'none';
        });
        
        // Mostrar el método seleccionado
        if (metodo === 'efectivo') {
            document.getElementById('pagoEfectivo').style.display = 'block';
        } else if (metodo === 'yape') {
            document.getElementById('pagoYape').style.display = 'block';
        } else if (metodo === 'tarjeta') {
            document.getElementById('pagoTarjeta').style.display = 'block';
        }
    }

    document.getElementById("monto_pagado").addEventListener("input", calcularVuelto);
    
    function calcularVuelto() {
        let precioText = document.getElementById("precio").value;
        let precio = parseFloat(precioText.replace('S/', ''));
        let montoPagado = parseFloat(document.getElementById("monto_pagado").value) || 0;
        let vuelto = montoPagado - precio;
        
        const vueltoElement = document.getElementById("vuelto");
        vueltoElement.textContent = vuelto >= 0 ? 'S/' + vuelto.toFixed(2) : "Monto insuficiente";
            
        if(vuelto >= 0) {
            vueltoElement.classList.remove('text-danger');
            vueltoElement.classList.add('text-success');
        } else {
            vueltoElement.classList.remove('text-success');
            vueltoElement.classList.add('text-danger');
        }
    }

    function setMonto(valor) {
        document.getElementById('monto_pagado').value = valor;
        calcularVuelto();
    }

    function setMontoExacto() {
        let precioText = document.getElementById("precio").value;
        let precio = parseFloat(precioText.replace('S/', ''));
        document.getElementById('monto_pagado').value = precio;
        calcularVuelto();
    }

    function procesarCobro() {
        let id = document.getElementById('alquiler_id').value;
        let metodo = document.querySelector('input[name="metodo_pago"]:checked').value;
        let montoPagado = metodo === "efectivo" ? parseFloat(document.getElementById('monto_pagado').value) : null;

        if (metodo === "efectivo" && (isNaN(montoPagado) || montoPagado <= 0)) {
            Swal.fire({
                icon: 'error',
                title: 'Error',
                text: 'Ingrese un monto válido para efectivo',
                confirmButtonColor: '#3085d6'
            });
            return;
        }

        // Verificar si el monto es suficiente
        if (metodo === "efectivo") {
            let precioText = document.getElementById("precio").value;
            let precio = parseFloat(precioText.replace('S/', ''));
            if (montoPagado < precio) {
                Swal.fire({
                    icon: 'error',
                    title: 'Monto insuficiente',
                    text: 'El monto pagado debe ser igual o mayor al precio total',
                    confirmButtonColor: '#3085d6'
                });
                return;
            }
        }

        Swal.fire({
            title: 'Confirmar Cobro',
            html: `¿Estás seguro de procesar el cobro por <b>${document.getElementById('precio').value}</b>?`,
            icon: 'question',
            imageUrl: 'imagenes/cobro.png',
            imageWidth: 100,
            imageHeight: 100,
            imageAlt: 'Confirmación de cobro',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: '<i class="fas fa-check-circle"></i> Sí, cobrar',
            cancelButtonText: '<i class="fas fa-times-circle"></i> Cancelar'
        }).then((result) => {
            if (result.isConfirmed) {
                let data = { 
                    metodo_pago: metodo,
                    _token: document.querySelector('meta[name="csrf-token"]').getAttribute('content')
                };
                
                if (metodo === "efectivo") {
                    data.monto = montoPagado;
                }

                $.ajax({
                    url: `/alquileres/cobrar/${id}`,
                    type: 'POST',
                    data: data,
                    success: function(response) {
                        Swal.fire({
                            icon: 'success',
                            title: 'Cobro realizado',
                            text: response.mensaje,
                            confirmButtonColor: '#3085d6'
                        }).then(() => {
                            if (response.mensaje.includes('éxito')) {
                                let cliente = document.getElementById('resumenCliente').textContent;
                                let pelicula = document.getElementById('resumenPelicula').textContent;
                                let precio = document.getElementById('resumenPrecio').textContent;
                                let horaEntrada = document.getElementById('resumenHoraEntrada').textContent;
                                let horaSalida = document.getElementById('resumenHoraSalida').textContent;
                                
                                $('#modalCobro').modal('hide');
                                
                                abrirModalTicket(id, cliente, pelicula, parseFloat(precio.replace('S/', '')), 
                                               horaEntrada, horaSalida, 'pagado', 'Sala');
                                
                                setTimeout(() => {
                                    location.reload();
                                }, 1000);
                            }
                        });
                    },
                    error: function(xhr) {
                        Swal.fire({
                            icon: 'error',
                            title: 'Error',
                            text: 'Hubo un error al procesar el cobro',
                            confirmButtonColor: '#3085d6'
                        });
                    }
                });
            }
        });
    }

    function abrirModalTicket(id, cliente, pelicula, precio, horaEntrada, horaSalida, estado, sala) {
        document.getElementById('downloadTicket').href = `/ticket/pdf/${id}`;
        
        const fechaActual = new Date();
        const opciones = { year: 'numeric', month: 'long', day: 'numeric', hour: '2-digit', minute: '2-digit' };
        document.getElementById('ticket-fecha').textContent = fechaActual.toLocaleDateString('es-ES', opciones);
        
        document.getElementById('ticket-id').textContent = `A-${id.toString().padStart(6, '0')}`;
        document.getElementById('ticket-cliente').textContent = cliente;
        document.getElementById('ticket-pelicula').textContent = pelicula;
        document.getElementById('ticket-sala').textContent = sala;
        document.getElementById('ticket-hora-entrada').textContent = horaEntrada;
        document.getElementById('ticket-hora-salida').textContent = horaSalida;
        document.getElementById('ticket-precio').textContent = `S/${precio.toFixed(2)}`;
        
        const estadoElement = document.getElementById('ticket-estado');
        estadoElement.textContent = estado.toUpperCase();
        estadoElement.className = estado === 'pagado' ? 'text-success font-weight-bold' : 'text-warning font-weight-bold';
        
        $('#modalTicket').modal('show');
    }

    function imprimirTicket() {
        const contenidoTicket = document.getElementById('ticket-container').innerHTML;
        const ventanaImpresion = window.open('', '_blank', 'height=600,width=800');
        
        ventanaImpresion.document.write(`
            <html>
                <head>
                    <title>Ticket de Alquiler</title>
                    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@4.6.0/dist/css/bootstrap.min.css">
                    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
                    <style>
                        body {
                            font-family: 'Courier New', monospace;
                            width: 80mm;
                            margin: 0 auto;
                            padding: 10px;
                        }
                        @media print {
                            body {
                                width: 100%;
                            }
                        }
                    </style>
                </head>
                <body>
                    ${contenidoTicket}
                </body>
            </html>
        `);
        
        ventanaImpresion.document.close();
        ventanaImpresion.focus();
        
        setTimeout(() => {
            ventanaImpresion.print();
            ventanaImpresion.close();
        }, 300);
    }

    function eliminarAlquiler(id) {
        Swal.fire({
            title: '¿Eliminar alquiler?',
            text: "Esta acción no se puede deshacer",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: '<i class="fas fa-trash"></i> Sí, eliminar',
            cancelButtonText: '<i class="fas fa-times"></i> Cancelar'
        }).then((result) => {
            if (result.isConfirmed) {
                $.ajax({
                    url: `/alquileres/${id}`,
                    type: 'DELETE',
                    data: {
                        _token: document.querySelector('meta[name="csrf-token"]').content
                    },
                    success: function(response) {
                        if (response.success) {
                            Swal.fire({
                                icon: 'success',
                                title: 'Eliminado',
                                text: 'El alquiler ha sido eliminado',
                                confirmButtonColor: '#3085d6'
                            }).then(() => {
                                location.reload();
                            });
                        } else {
                            Swal.fire({
                                icon: 'error',
                                title: 'Error',
                                text: 'No se pudo eliminar el alquiler',
                                confirmButtonColor: '#3085d6'
                            });
                        }
                    },
                    error: function() {
                        Swal.fire({
                            icon: 'error',
                            title: 'Error',
                            text: 'Ocurrió un error al intentar eliminar',
                            confirmButtonColor: '#3085d6'
                        });
                    }
                });
            }
        });
    }
</script>


<style>
    /* Estilos generales mejorados */
    .bg-gradient-primary {
        background: linear-gradient(135deg, #4776E6 0%, #8E54E9 100%) !important;
    }
    
    .bg-gradient-secondary {
        background: linear-gradient(135deg, #606c88 0%, #3f4c6b 100%) !important;
    }
    
    .bg-gradient-light {
        background: linear-gradient(135deg, #f8f9fa 0%, #edf1f7 100%) !important;
    }
    
    .modal-content {
        border-radius: 0.75rem;
        overflow: hidden;
        border: none;
    }
    
    .modal-header {
        padding: 1.25rem 1.5rem;
        border-bottom: none;
    }
    
    .modal-body {
        padding: 1.5rem;
    }
    
    .modal-footer {
        border-top: 1px solid #eee;
        padding: 1rem 1.5rem;
    }
    
    .input-group-lg .form-control,
    .input-group-lg .input-group-prepend .input-group-text {
        height: calc(2.875rem + 2px);
        padding: 0.5rem 1rem;
        font-size: 1.1rem;
    }
    
    /* Estilos para las tarjetas y tablas */
    .card {
        border-radius: 0.75rem;
        border: none;
        transition: all 0.3s ease;
    }
    
    .card-header {
        border-bottom: 1px solid rgba(0, 0, 0, 0.05);
        padding: 1rem 1.25rem;
    }
    
    .table th {
        background-color: #343a40;
        color: white;
        border-color: #454d55;
    }
    
    .table-hover tbody tr:hover {
        background-color: rgba(0, 123, 255, 0.075);
        transition: background-color 0.15s ease-in-out;
    }
    
    /* Estilos para botones y badges */
    .btn {
        border-radius: 0.5rem;
        font-weight: 500;
        transition: all 0.2s;
    }
    
    .btn-group .btn {
        border-radius: 0;
    }
    
    .btn-group .btn:first-child {
        border-top-left-radius: 0.5rem;
        border-bottom-left-radius: 0.5rem;
    }
    
    .btn-group .btn:last-child {
        border-top-right-radius: 0.5rem;
        border-bottom-right-radius: 0.5rem;
    }
    
    .badge {
        font-weight: 500;
        letter-spacing: 0.5px;
    }
    
    /* Estilos para el ticket */
    #ticket-container {
        max-width: 380px;
        margin: 0 auto;
        font-size: 0.9rem;
    }
    
    /* Animaciones y efectos */
    @keyframes fadeIn {
        from { opacity: 0; }
        to { opacity: 1; }
    }
    
    .modal.fade .modal-dialog {
        transition: transform 0.3s ease-out;
    }
    
    .modal.show .modal-dialog {
        animation: fadeIn 0.3s;
    }
    
    /* Mejoras para dispositivos móviles */
    @media (max-width: 767.98px) {
        .modal-dialog {
            margin: 0.5rem;
        }
        
        .btn-group-toggle {
            flex-direction: column;
        }
        
        .btn-group-toggle .btn {
            border-radius: 0.5rem;
            margin-bottom: 0.5rem;
        }
    }

    /* Estilos para los métodos de pago */
    .btn-group-toggle .btn.active {
        box-shadow: 0 0 0 0.2rem rgba(0, 123, 255, 0.25);
    }
    
    /* Estilos para las alertas y notificaciones */
    .alert {
        border-radius: 0.5rem;
    }
    
    /* Mejoras visuales para la tabla */
    .table {
        margin-bottom: 0;
    }
    
    .table td {
        vertical-align: middle;
    }
    
    /* Mejoras para el listado de resumen */
    .list-group-item {
        border-color: rgba(0, 0, 0, 0.05);
        padding: 0.75rem 0;
    }
</style>
