@extends('adminlte::page')

@section('title', 'Detalles del Alquiler')

<head>
    <link rel="icon" href="{{ asset('icons/servicio.png') }}" type="image/x-icon">
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/animate.css/4.1.1/animate.min.css">
</head>

@section('content_header')
    
@endsection

@section('content')
    <div class="row">
        <!-- Información Principal -->
        <div class="col-lg-8">
            <div class="card card-glass animate__animated animate__fadeInLeft">
                <div class="card-header bg-gradient-primary text-white">
                    <div class="d-flex justify-content-between align-items-center">
                        <h3 class="card-title mb-0">
                            <i class="fas fa-info-circle mr-2"></i>Información del Alquiler
                        </h3>
                        <span class="badge badge-pill badge-light">
                            ID: {{ $alquiler->id }}
                        </span>
                    </div>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-6">
                            <!-- Película -->
                            <div class="info-card mb-4 hover-effect" data-aos="fade-up">
                                <div class="icon-circle bg-primary-light">
                                    <i class="fas fa-film text-primary"></i>
                                </div>
                                <div class="info-content">
                                    <label class="info-label">Película</label>
                                    <h5 class="info-value">{{ $alquiler->pelicula?->titulo ?? 'Película no encontrada' }}</h5>
                                </div>
                            </div>
                            
                            <!-- Cliente -->
                            <div class="info-card mb-4 hover-effect" data-aos="fade-up" data-aos-delay="100">
                                <div class="icon-circle bg-success-light">
                                    <i class="fas fa-user text-success"></i>
                                </div>
                                <div class="info-content">
                                    <label class="info-label">Cliente</label>
                                    <h5 class="info-value">{{ $alquiler->cliente }}</h5>
                                </div>
                            </div>
                            
                            <!-- Sala -->
                            <div class="info-card mb-4 hover-effect" data-aos="fade-up" data-aos-delay="150">
                                <div class="icon-circle bg-warning-light">
                                    <i class="fas fa-door-open text-warning"></i>
                                </div>
                                <div class="info-content">
                                    <label class="info-label">Sala</label>
                                    <h5 class="info-value">{{ $alquiler->sala?->nombre ?? 'Sala no encontrada' }}</h5>
                                </div>
                            </div>
                        </div>
                        
                        <div class="col-md-6">
                            <!-- Hora Inicio -->
                            <div class="info-card mb-4 hover-effect" data-aos="fade-up">
                                <div class="icon-circle bg-info-light">
                                    <i class="fas fa-clock text-info"></i>
                                </div>
                                <div class="info-content">
                                    <label class="info-label">Hora de Inicio</label>
                                    <h5 class="info-value">{{ $alquiler->hora_entrada }}</h5>
                                </div>
                            </div>
                            
                            <!-- Hora Fin -->
                            <div class="info-card mb-4 hover-effect" data-aos="fade-up" data-aos-delay="100">
                                <div class="icon-circle bg-danger-light">
                                    <i class="fas fa-clock text-danger"></i>
                                </div>
                                <div class="info-content">
                                    <label class="info-label">Hora de Fin</label>
                                    <h5 class="info-value">{{ $alquiler->hora_salida }}</h5>
                                </div>
                            </div>
                            
                            <!-- Estado -->
                            <div class="info-card mb-4 hover-effect" data-aos="fade-up" data-aos-delay="150">
                                <div class="icon-circle bg-secondary-light">
                                    <i class="fas fa-tag text-secondary"></i>
                                </div>
                                <div class="info-content">
                                    <label class="info-label">Estado</label>
                                    @php
                                        $estadoClase = [
                                            'Pendiente' => 'badge-gradient-warning',
                                            'Completado' => 'badge-gradient-success',
                                            'Cancelado' => 'badge-gradient-danger',
                                            'En progreso' => 'badge-gradient-info'
                                        ][$alquiler->estado] ?? 'badge-gradient-secondary';
                                    @endphp
                                    <span class="badge {{ $estadoClase }} badge-pill">{{ $alquiler->estado }}</span>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <!-- Timeline -->
                    <div class="timeline-wrapper mt-4" data-aos="zoom-in">
                        <h5 class="section-title mb-4">
                            <i class="fas fa-history mr-2"></i>Linea de Tiempo
                        </h5>
                        
                        @php
                            $horaEntrada = \Carbon\Carbon::parse($alquiler->hora_entrada);
                            $horaSalida = \Carbon\Carbon::parse($alquiler->hora_salida);
                            $duracion = $horaEntrada->diffInHours($horaSalida);
                            $minutos = $horaEntrada->diffInMinutes($horaSalida) % 60;
                        @endphp
                        
                        <div class="timeline">
                            <div class="timeline-item start">
                                <div class="timeline-point bg-primary">
                                    <i class="fas fa-play"></i>
                                </div>
                                <div class="timeline-content">
                                    <h6>Inicio</h6>
                                    <p>{{ $alquiler->hora_entrada }}</p>
                                </div>
                            </div>
                            
                            <div class="timeline-item duration">
                                <div class="timeline-point bg-success">
                                    <i class="fas fa-hourglass-half"></i>
                                </div>
                                <div class="timeline-content">
                                    <h6>Duración</h6>
                                    <p>{{ $duracion }}h {{ $minutos }}m</p>
                                </div>
                            </div>
                            
                            <div class="timeline-item end">
                                <div class="timeline-point bg-danger">
                                    <i class="fas fa-stop"></i>
                                </div>
                                <div class="timeline-content">
                                    <h6>Fin</h6>
                                    <p>{{ $alquiler->hora_salida }}</p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                
                
            </div>
        </div>
        
        <!-- Sidebar -->
        <div class="col-lg-4">
            <!-- Resumen -->
            <div class="card card-glass animate__animated animate__fadeInRight mb-4">
                <div class="card-header bg-gradient-info text-white">
                    <h3 class="card-title mb-0">
                        <i class="fas fa-receipt mr-2"></i>Resumen
                    </h3>
                </div>
                <div class="card-body">
                    <div class="stats-card">
                        <div class="stat-item">
                            <div class="stat-icon bg-primary-light">
                                <i class="fas fa-calendar-day text-primary"></i>
                            </div>
                            <div class="stat-info">
                                <label>Fecha</label>
                                <h5>{{ $alquiler->created_at->format('d M Y') }}</h5>
                            </div>
                        </div>
                        
                        <div class="stat-item">
                            <div class="stat-icon bg-success-light">
                                <i class="fas fa-stopwatch text-success"></i>
                            </div>
                            <div class="stat-info">
                                <label>Duración Total</label>
                                <h5>{{ $duracion }}h {{ $minutos }}m</h5>
                            </div>
                        </div>
                        
                        <div class="stat-item">
                            <div class="stat-icon bg-warning-light">
                                <i class="fas fa-money-bill-wave text-warning"></i>
                            </div>
                            <div class="stat-info">
                                <label>Precio</label>
                                <h5>S/ {{ number_format($alquiler->precio, 2) }}</h5>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            
            <!-- Quick Actions -->
            <div class="card card-glass animate__animated animate__fadeInRight animate__delay-1s">
                <div class="card-header bg-gradient-purple text-white">
                    <h3 class="card-title mb-0">
                        <i class="fas fa-bolt mr-2"></i>Acciones Rápidas
                    </h3>
                </div>
                <div class="card-body">
                    <div class="quick-actions">
                        <button class="action-btn bg-gradient-primary" data-toggle="modal" data-target="#modalPago">
                            <i class="fas fa-cash-register"></i>
                            <span>Registrar Pago</span>
                        </button>
                        
                        <button class="action-btn bg-gradient-success">
                            <i class="fas fa-envelope"></i>
                            <span>Enviar Recibo</span>
                        </button>
                        
                        <button class="action-btn bg-gradient-info">
                            <i class="fas fa-print"></i>
                            <span>Imprimir</span>
                        </button>
                        
                        <button class="action-btn bg-gradient-warning">
                            <i class="fas fa-calendar-plus"></i>
                            <span>Extender</span>
                        </button>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@section('css')
<style>
    :root {
        --primary: #6C63FF;
        --secondary: #4D44DB;
        --success: #4CC9F0;
        --info: #4895EF;
        --warning: #F8961E;
        --danger: #F72585;
        --light: #F8F9FA;
        --dark: #212529;
    }
    
    body {
        font-family: 'Poppins', sans-serif;
        background: linear-gradient(135deg, #f5f7fa 0%, #e4e8f0 100%);
        color: #4a4a4a;
    }
    
    .text-gradient-primary {
        background: linear-gradient(135deg, var(--primary) 0%, var(--secondary) 100%);
        -webkit-background-clip: text;
        -webkit-text-fill-color: transparent;
        display: inline-block;
    }
    
    .card-glass {
        background: rgba(255, 255, 255, 0.9);
        backdrop-filter: blur(10px);
        border: none;
        border-radius: 16px;
        box-shadow: 0 8px 32px rgba(31, 38, 135, 0.1);
        overflow: hidden;
        transition: all 0.3s ease;
    }
    
    .card-glass:hover {
        transform: translateY(-5px);
        box-shadow: 0 12px 40px rgba(31, 38, 135, 0.15);
    }
    
    .card-header {
        border-radius: 16px 16px 0 0 !important;
        padding: 1.25rem 1.5rem;
    }
    
    .bg-gradient-primary {
        background: linear-gradient(135deg, var(--primary) 0%, var(--secondary) 100%) !important;
    }
    
    .bg-gradient-info {
        background: linear-gradient(135deg, var(--info) 0%, #3A86FF 100%) !important;
    }
    
    .bg-gradient-purple {
        background: linear-gradient(135deg, #7B2CBF 0%, #9D4EDD 100%) !important;
    }
    
    .bg-gradient-success {
        background: linear-gradient(135deg, var(--success) 0%, #4895EF 100%) !important;
    }
    
    .bg-gradient-warning {
        background: linear-gradient(135deg, var(--warning) 0%, #F3722C 100%) !important;
    }
    
    .bg-gradient-danger {
        background: linear-gradient(135deg, var(--danger) 0%, #B5179E 100%) !important;
    }
    
    .info-card {
        display: flex;
        align-items: center;
        padding: 1rem;
        border-radius: 12px;
        background: white;
        box-shadow: 0 4px 12px rgba(0,0,0,0.05);
        transition: all 0.3s ease;
    }
    
    .hover-effect:hover {
        transform: translateY(-3px);
        box-shadow: 0 8px 20px rgba(0,0,0,0.1);
    }
    
    .icon-circle {
        width: 48px;
        height: 48px;
        border-radius: 50%;
        display: flex;
        align-items: center;
        justify-content: center;
        margin-right: 1rem;
        font-size: 1.25rem;
    }
    
    .bg-primary-light {
        background-color: rgba(108, 99, 255, 0.1);
    }
    
    .bg-success-light {
        background-color: rgba(76, 201, 240, 0.1);
    }
    
    .bg-info-light {
        background-color: rgba(72, 149, 239, 0.1);
    }
    
    .bg-warning-light {
        background-color: rgba(248, 150, 30, 0.1);
    }
    
    .bg-danger-light {
        background-color: rgba(247, 37, 133, 0.1);
    }
    
    .bg-secondary-light {
        background-color: rgba(33, 37, 41, 0.1);
    }
    
    .info-label {
        font-size: 0.75rem;
        text-transform: uppercase;
        letter-spacing: 1px;
        color: #6c757d;
        margin-bottom: 0.25rem;
        font-weight: 600;
    }
    
    .info-value {
        font-size: 1.1rem;
        font-weight: 500;
        color: #343a40;
        margin-bottom: 0;
    }
    
    .badge-gradient {
        color: white;
        font-weight: 500;
        letter-spacing: 0.5px;
    }
    
    .btn-round {
        border-radius: 50px !important;
        padding: 0.5rem 1.5rem;
        font-weight: 500;
        letter-spacing: 0.5px;
        position: relative;
        overflow: hidden;
    }
    
    .btn-glow:hover {
        box-shadow: 0 0 15px rgba(108, 99, 255, 0.5);
    }
    
    .section-title {
        font-size: 1.1rem;
        font-weight: 600;
        color: #495057;
        position: relative;
        padding-bottom: 0.5rem;
    }
    
    .section-title::after {
        content: '';
        position: absolute;
        left: 0;
        bottom: 0;
        width: 50px;
        height: 3px;
        background: linear-gradient(135deg, var(--primary) 0%, var(--secondary) 100%);
        border-radius: 3px;
    }
    
    /* Timeline */
    .timeline {
        position: relative;
        padding-left: 50px;
    }
    
    .timeline::before {
        content: '';
        position: absolute;
        left: 20px;
        top: 0;
        bottom: 0;
        width: 2px;
        background: linear-gradient(to bottom, var(--primary), var(--success), var(--danger));
    }
    
    .timeline-item {
        position: relative;
        margin-bottom: 1.5rem;
    }
    
    .timeline-point {
        position: absolute;
        left: -50px;
        width: 40px;
        height: 40px;
        border-radius: 50%;
        display: flex;
        align-items: center;
        justify-content: center;
        color: white;
        font-size: 1rem;
        box-shadow: 0 4px 12px rgba(0,0,0,0.1);
    }
    
    .timeline-content {
        background: white;
        padding: 1rem;
        border-radius: 8px;
        box-shadow: 0 4px 12px rgba(0,0,0,0.05);
    }
    
    .timeline-content h6 {
        font-weight: 600;
        margin-bottom: 0.25rem;
        color: var(--primary);
    }
    
    .timeline-content p {
        margin-bottom: 0;
        color: #6c757d;
        font-size: 0.9rem;
    }
    
    /* Stats Card */
    .stats-card {
        display: flex;
        flex-direction: column;
        gap: 1rem;
    }
    
    .stat-item {
        display: flex;
        align-items: center;
        padding: 0.75rem;
        border-radius: 10px;
        background: white;
        box-shadow: 0 4px 12px rgba(0,0,0,0.05);
    }
    
    .stat-icon {
        width: 40px;
        height: 40px;
        border-radius: 50%;
        display: flex;
        align-items: center;
        justify-content: center;
        margin-right: 1rem;
        font-size: 1rem;
    }
    
    .stat-info label {
        font-size: 0.75rem;
        text-transform: uppercase;
        letter-spacing: 1px;
        color: #6c757d;
        margin-bottom: 0.25rem;
        font-weight: 600;
    }
    
    .stat-info h5 {
        font-size: 1.1rem;
        font-weight: 500;
        color: #343a40;
        margin-bottom: 0;
    }
    
    /* Quick Actions */
    .quick-actions {
        display: grid;
        grid-template-columns: repeat(2, 1fr);
        gap: 0.75rem;
    }
    
    .action-btn {
        border: none;
        border-radius: 10px;
        padding: 1rem;
        color: white;
        display: flex;
        flex-direction: column;
        align-items: center;
        justify-content: center;
        text-align: center;
        transition: all 0.3s ease;
        cursor: pointer;
    }
    
    .action-btn:hover {
        transform: translateY(-3px);
        box-shadow: 0 8px 20px rgba(0,0,0,0.1);
    }
    
    .action-btn i {
        font-size: 1.5rem;
        margin-bottom: 0.5rem;
    }
    
    .action-btn span {
        font-size: 0.75rem;
        font-weight: 500;
    }
    
    /* Animations */
    [data-aos] {
        transition: all 0.5s ease;
    }
    
    /* Responsive */
    @media (max-width: 992px) {
        .quick-actions {
            grid-template-columns: 1fr;
        }
    }
</style>
@endsection

@section('js')
<script src="https://cdn.jsdelivr.net/npm/aos@2.3.4/dist/aos.js"></script>
<script>
    $(document).ready(function() {
        // Initialize animations
        AOS.init({
            duration: 800,
            easing: 'ease-in-out',
            once: true
        });
        
        // Add ripple effect to buttons
        $('.btn').on('click', function(e) {
            var x = e.pageX - $(this).offset().left;
            var y = e.pageY - $(this).offset().top;
            
            var $ripple = $('<span class="ripple-effect"></span>');
            $ripple.css({
                left: x,
                top: y
            });
            
            $(this).append($ripple);
            
            setTimeout(function() {
                $ripple.remove();
            }, 1000);
        });
    });
</script>
@endsection