@extends('adminlte::page')

@section('title', ' Categoria')

<head>
    <link rel="icon" href="{{ asset('icons/categoria.png') }}" type="image/x-icon">
</head>

@section('content_header')
<!-- Bootstrap 5 CSS -->
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/css/bootstrap.min.css" rel="stylesheet">

<!-- Bootstrap 5 JS (necesario para algunos componentes interactivos) -->
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/js/bootstrap.bundle.min.js"></script>
<!-- Incluir SweetAlert2 desde CDN -->
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

<style>
    /* Paleta de colores aplicada */
    .btn-primary {
        background-color: #27ae60;
        border-color: #27ae60;
    }
    
    .btn-primary:hover, 
    .btn-primary:focus, 
    .btn-primary:active {
        background-color: #219150 !important;
        border-color: #219150 !important;
    }
    
    .bg-primary {
        background-color: #27ae60 !important;
    }
    
    .alert-success {
        background-color: rgba(39, 174, 96, 0.1);
        border-color: #27ae60;
        color: #27ae60;
    }
    
    .btn-danger {
        background-color: #e74c3c;
        border-color: #e74c3c;
    }
    
    .btn-danger:hover,
    .btn-danger:focus,
    .btn-danger:active {
        background-color: #c0392b !important;
        border-color: #c0392b !important;
    }
    
    .form-control {
        border-color: #ccc;
    }
    
    .form-control:focus {
        border-color: #27ae60;
        box-shadow: 0 0 0 0.25rem rgba(39, 174, 96, 0.25);
    }
    
    .modal-header .btn-close:focus {
        box-shadow: 0 0 0 0.25rem rgba(39, 174, 96, 0.25);
    }
    
    /* Mantener la misma funcionalidad para el botón de warning */
    .btn-warning {
        background-color: #f39c12;
        border-color: #f39c12;
    }
    
    .btn-warning:hover,
    .btn-warning:focus,
    .btn-warning:active {
        background-color: #e67e22 !important;
        border-color: #e67e22 !important;
    }
</style>
@stop

@section('content')
@can('crear peliculas')
<div class="card">
    <div class="card-body">
        @if (session('success'))
            <div class="alert alert-success">{{ session('success') }}</div>
        @endif
        <button class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#createCategoryModal">
            <i class="fas fa-plus-circle"></i> Nueva Categoría
        </button>

        <!-- Tabla de categorías -->
        <table class="table table-bordered table-striped table-hover mt-4">
            <thead class="bg-primary text-white text-center">
                <tr>
                    <th>ID</th>
                    <th>Nombre</th>
                    <th>Acciones</th>
                </tr>
            </thead>
            <tbody class="text-center">
                @foreach ($categorias as $categoria)
                    <tr>
                        <td>{{ $categoria->id }}</td>
                        <td>{{ $categoria->nombre }}</td>
                        <td>
                            <a href="{{ route('categorias.edit', $categoria) }}" class="btn btn-warning btn-sm" aria-label="Editar categoría">
                                <i class="fas fa-edit"></i> Editar
                            </a>
                            <form action="{{ route('categorias.destroy', $categoria) }}" method="POST" class="d-inline delete-form" aria-label="Eliminar categoría">
                                @csrf
                                @method('DELETE')
                                <button type="submit" class="btn btn-danger btn-sm">
                                    <i class="fas fa-trash-alt"></i> Eliminar
                                </button>
                            </form>
                        </td>
                    </tr>
                @endforeach
            </tbody>
        </table>
    </div>
</div>

<!-- Modal para Crear Categoría -->
<div class="modal fade" id="createCategoryModal" tabindex="-1" aria-labelledby="createCategoryModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="createCategoryModalLabel">Crear Nueva Categoría</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Cerrar"></button>
            </div>
            <div class="modal-body">
                <!-- Formulario de creación de categoría -->
                <form action="{{ route('categorias.store') }}" method="POST">
                    @csrf
                    <div class="mb-3">
                        <label for="nombre" class="form-label">Nombre de la Categoría</label>
                        <input type="text" class="form-control" id="nombre" name="nombre" required>
                    </div>
                    <div class="mb-3 text-center">
                        <button type="submit" class="btn btn-primary">Crear Categoría</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
@endcan
@stop


@section('footer')
    <div class="text-center">
      
    </div>
@stop
@section('js')
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/js/bootstrap.bundle.min.js"></script>

<script>
    document.querySelectorAll('.delete-form').forEach(form => {
        form.addEventListener('submit', function(event) {
            event.preventDefault();
            // Usamos SweetAlert2 para confirmar la eliminación
            Swal.fire({
                title: '¿Estás seguro?',
                text: "¡No podrás revertir esta acción!",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#e74c3c',
                cancelButtonColor: '#aaa',
                confirmButtonText: 'Sí, eliminar!',
                cancelButtonText: 'Cancelar',
                reverseButtons: true
            }).then((result) => {
                if (result.isConfirmed) {
                    form.submit();  // Enviamos el formulario después de la confirmación
                }
            });
        });
    });
</script>
@stop