@extends('adminlte::page')

@section('title', 'Cinestacion Dashboard')

<head>
    <link rel="icon" href="{{ asset('imagenes/icon.png') }}" type="image/x-icon">
    <style>
        :root {
            --primary-color: #3498db;
            --secondary-color: #2ecc71;
            --accent-color: #e74c3c;
            --dark-color: #2c3e50;
            --light-color: #ecf0f1;
            --text-dark: #333;
            --text-light: #fff;
        }
        
        .theme-dark {
            --primary-color: #9b59b6;
            --secondary-color: #1abc9c;
            --accent-color: #e74c3c;
            --dark-color: #34495e;
            --light-color: #2c3e50;
            --text-dark: #ecf0f1;
            --text-light: #bdc3c7;
        }
        
        .theme-corporate {
            --primary-color: #2980b9;
            --secondary-color: #16a085;
            --accent-color: #c0392b;
            --dark-color: #2c3e50;
            --light-color: #f9f9f9;
            --text-dark: #333;
            --text-light: #7f8c8d;
        }
        
        body {
            background-color: var(--light-color);
            color: var(--text-dark);
            transition: all 0.3s ease;
        }
        
        .card {
            border: none;
            border-radius: 10px;
            box-shadow: 0 4px 20px rgba(0, 0, 0, 0.08);
            transition: transform 0.3s ease, box-shadow 0.3s ease;
            background-color: white;
        }
        
        .card:hover {
            transform: translateY(-5px);
            box-shadow: 0 10px 25px rgba(0, 0, 0, 0.12);
        }
        
        .metric-card {
            border-left: 4px solid var(--primary-color);
            border-radius: 8px;
            transition: all 0.3s ease;
        }
        
        .metric-card:hover {
            transform: translateY(-3px);
            box-shadow: 0 6px 15px rgba(0, 0, 0, 0.1);
        }
        
        .quick-action {
            cursor: pointer;
            transition: all 0.2s ease;
            border-radius: 8px;
        }
        
        .quick-action:hover {
            transform: scale(1.03);
            box-shadow: 0 5px 15px rgba(0, 0, 0, 0.1);
        }
        
        .theme-selector {
            position: fixed;
            bottom: 20px;
            right: 20px;
            z-index: 1000;
        }
        
        .theme-btn {
            width: 40px;
            height: 40px;
            border-radius: 50%;
            border: 2px solid white;
            cursor: pointer;
            margin: 5px;
            box-shadow: 0 2px 5px rgba(0, 0, 0, 0.2);
        }
        
        .alert-notification {
            position: fixed;
            top: 20px;
            right: 20px;
            z-index: 1000;
            max-width: 300px;
            display: none;
        }
        
        .progress-thin {
            height: 8px;
            border-radius: 4px;
        }
        
        .badge-pill {
            padding: 5px 10px;
            border-radius: 50px;
        }
        
        .hover-effect {
            transition: all 0.3s ease;
        }
        
        .hover-effect:hover {
            background-color: rgba(0, 0, 0, 0.02);
        }
    </style>
</head>

@section('content_header')
    @if($alertaSalas)
    <div class="alert alert-danger alert-dismissible fade show" role="alert">
        <i class="fas fa-exclamation-triangle mr-2"></i>
        <strong>Atención!</strong> Solo quedan {{ $salasDisponibles }} salas disponibles.
        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
            <span aria-hidden="true">&times;</span>
        </button>
    </div>
    @endif
@endsection

@section('content')
<div class="container-fluid">
    <!-- Theme Selector Floating Button -->
    <div class="theme-selector btn-group dropup">
        <button class="btn btn-dark rounded-circle" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
            <i class="fas fa-palette"></i>
        </button>
        <div class="dropdown-menu dropdown-menu-right p-2">
            <button class="theme-btn bg-primary" data-theme="default"></button>
            <button class="theme-btn bg-dark" data-theme="dark"></button>
            <button class="theme-btn bg-white" data-theme="corporate"></button>
        </div>
    </div>

    <!-- Notification Alert (Hidden by default) -->
    <div class="alert alert-success alert-notification fade show" role="alert">
        <i class="fas fa-check-circle mr-2"></i>
        <span id="notification-message">Operación realizada con éxito</span>
    </div>

    <!-- Quick Actions Row -->
    <div class="row mb-4">
        <div class="col-md-3 col-sm-6 mb-3">
            <div class="card quick-action bg-primary text-white" onclick="window.location='{{ route('peliculas.create') }}'">
                <div class="card-body text-center py-3">
                    <i class="fas fa-plus-circle fa-2x mb-2"></i>
                    <h6 class="mb-0">Nueva Película</h6>
                </div>
            </div>
        </div>
        <div class="col-md-3 col-sm-6 mb-3">
            <div class="card quick-action bg-success text-white" onclick="window.location='{{ route('alquileres.create') }}'">
                <div class="card-body text-center py-3">
                    <i class="fas fa-handshake fa-2x mb-2"></i>
                    <h6 class="mb-0">Nuevo Alquiler</h6>
                </div>
            </div>
        </div>
        <div class="col-md-3 col-sm-6 mb-3">
            <div class="card quick-action bg-info text-white" onclick="window.location='{{ route('productos.create') }}'">
                <div class="card-body text-center py-3">
                    <i class="fas fa-box-open fa-2x mb-2"></i>
                    <h6 class="mb-0">Nuevo Producto</h6>
                </div>
            </div>
        </div>
        <div class="col-md-3 col-sm-6 mb-3">
            <div class="card quick-action bg-warning text-dark" onclick="window.location='{{ route('reporte.index') }}'">
                <div class="card-body text-center py-3">
                    <i class="fas fa-file-pdf fa-2x mb-2"></i>
                    <h6 class="mb-0">Generar Reporte</h6>
                </div>
            </div>
        </div>
    </div>

    <!-- Metrics Overview -->
    <div class="row">
        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card metric-card border-left-primary h-100">
                <div class="card-body">
                    <div class="d-flex justify-content-between align-items-center">
                        <div>
                            <span class="text-muted">Películas Disponibles</span>
                            <h3 class="mb-0">{{ $totalPeliculas }}</h3>
                        </div>
                        <div class="bg-primary rounded-circle p-3">
                            <i class="fas fa-film text-white fa-2x"></i>
                        </div>
                    </div>
                    <div class="mt-3">
                        <div class="progress progress-thin">
                            <div class="progress-bar bg-primary" style="width: {{ ($totalPeliculas/50)*100 }}%"></div>
                        </div>
                        <small class="text-muted">Total en catálogo</small>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card metric-card border-left-success h-100" onclick="window.location='{{ route('alquileres.index') }}'" style="cursor: pointer;">
                <div class="card-body">
                    <div class="d-flex justify-content-between align-items-center">
                        <div>
                            <span class="text-muted">Alquileres Activos</span>
                            <h3 class="mb-0">{{ $totalAlquileres }}</h3>
                        </div>
                        <div class="bg-success rounded-circle p-3">
                            <i class="fas fa-handshake text-white fa-2x"></i>
                        </div>
                    </div>
                    <div class="mt-3">
                        <div class="progress progress-thin">
                            <div class="progress-bar bg-success" style="width: {{ ($totalAlquileres/20)*100 }}%"></div>
                        </div>
                        <small class="text-muted">En curso</small>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card metric-card border-left-info h-100">
                <div class="card-body">
                    <div class="d-flex justify-content-between align-items-center">
                        <div>
                            <span class="text-muted">Salas Disponibles</span>
                            <h3 class="mb-0">{{ $salasDisponibles }}</h3>
                        </div>
                        <div class="bg-info rounded-circle p-3">
                            <i class="fas fa-door-open text-white fa-2x"></i>
                        </div>
                    </div>
                    <div class="mt-3">
                        <div class="progress progress-thin">
                            <div class="progress-bar bg-info" style="width: {{ ($salasDisponibles/10)*100 }}%"></div>
                        </div>
                        <small class="text-muted">De 10 salas totales</small>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card metric-card border-left-warning h-100">
                <div class="card-body">
                    <div class="d-flex justify-content-between align-items-center">
                        <div>
                            <span class="text-muted">Ingresos Hoy</span>
                            <h3 class="mb-0">S/. {{ number_format($ingresosTotalesHoy, 2) }}</h3>
                        </div>
                        <div class="bg-warning rounded-circle p-3">
                            <i class="fas fa-dollar-sign text-white fa-2x"></i>
                        </div>
                    </div>
                    <div class="mt-3">
                        <div class="progress progress-thin">
                            <div class="progress-bar bg-warning" style="width: {{ ($ingresosTotalesHoy/5000)*100 }}%"></div>
                        </div>
                        <small class="text-muted">Meta diaria: S/. 5,000</small>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Charts Section -->
    <div class="row mb-4">
        <div class="col-lg-6 mb-4">
            <div class="card h-100">
                <div class="card-header bg-white border-0 d-flex justify-content-between align-items-center">
                    <h5 class="mb-0"><i class="fas fa-chart-line text-primary mr-2"></i>Ingresos por Alquileres</h5>
                    <div class="dropdown">
                        <button class="btn btn-sm btn-outline-secondary dropdown-toggle" type="button" id="dropdownMenuButton" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                            Últimos 7 días
                        </button>
                        <div class="dropdown-menu dropdown-menu-right" aria-labelledby="dropdownMenuButton">
                            <a class="dropdown-item" href="#" onclick="filterChartData(7)">Últimos 7 días</a>
                            <a class="dropdown-item" href="#" onclick="filterChartData(30)">Últimos 30 días</a>
                            <a class="dropdown-item" href="#" onclick="filterChartData(90)">Últimos 90 días</a>
                        </div>
                    </div>
                </div>
                <div class="card-body">
                    <canvas id="rentalsChart" height="250"></canvas>
                </div>
            </div>
        </div>

        <div class="col-lg-6 mb-4">
            <div class="card h-100">
                <div class="card-header bg-white border-0">
                    <h5 class="mb-0"><i class="fas fa-chart-pie text-success mr-2"></i>Distribución de Ingresos</h5>
                </div>
                <div class="card-body">
                    <canvas id="incomeDistributionChart" height="250"></canvas>
                </div>
                <div class="card-footer bg-white border-0">
                    <div class="row text-center">
                        <div class="col-6">
                            <span class="text-muted">Películas:</span>
                            <h5 class="mb-0">S/. {{ number_format($ingresosDiariosPeliculas, 2) }}</h5>
                        </div>
                        <div class="col-6">
                            <span class="text-muted">Productos:</span>
                            <h5 class="mb-0">S/. {{ number_format($ingresosDiariosProductos, 2) }}</h5>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Data Tables Section -->
    <div class="row">
        <div class="col-lg-6 mb-4">
            <div class="card h-100">
                <div class="card-header bg-white border-0 d-flex justify-content-between align-items-center">
                    <h5 class="mb-0"><i class="fas fa-star text-warning mr-2"></i>Películas Más Rentadas</h5>
                    <a href="{{ route('peliculas.index') }}" class="btn btn-sm btn-outline-primary">Ver todas</a>
                </div>
                <div class="card-body p-0">
                    <div class="table-responsive">
                        <table class="table table-hover mb-0">
                            <thead class="thead-light">
                                <tr>
                                    <th>Película</th>
                                    <th>Alquileres</th>
                                    <th>Popularidad</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($topPeliculas as $pelicula)
                                <tr class="hover-effect">
                                    <td>
                                        <div class="d-flex align-items-center">
                                            <img src="{{ $pelicula->imagen_url ?? asset('imagenes/default-movie.png') }}" alt="{{ $pelicula->nombre }}" class="rounded-circle mr-2" width="30" height="30">
                                            <span>{{ Str::limit($pelicula->nombre, 25) }}</span>
                                        </div>
                                    </td>
                                    <td>{{ $pelicula->total }}</td>
                                    <td>
                                        <div class="progress progress-thin">
                                            <div class="progress-bar bg-{{ $loop->index < 3 ? 'success' : 'info' }}" style="width: {{ ($pelicula->total / $topPeliculas->first()->total) * 100 }}%"></div>
                                        </div>
                                    </td>
                                </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-lg-6 mb-4">
            <div class="card h-100">
                <div class="card-header bg-white border-0 d-flex justify-content-between align-items-center">
                    <h5 class="mb-0"><i class="fas fa-history text-info mr-2"></i>Últimos Pagos</h5>
                    <a href="" class="btn btn-sm btn-outline-primary">Ver historial</a>
                </div>
                <div class="card-body p-0">
                    <div class="list-group list-group-flush">
                        @foreach($ultimosCobros as $cobro)
                        <div class="list-group-item border-0 hover-effect">
                            <div class="d-flex justify-content-between align-items-center">
                                <div>
                                    <h6 class="mb-1">{{ $cobro->titulo }}</h6>
                                    <small class="text-muted">{{ $cobro->fecha_cobro }}</small>
                                </div>
                                <div class="text-right">
                                    <span class="badge badge-pill bg-success text-white">S/. {{ number_format($cobro->precio, 2) }}</span>
                                    <div class="text-muted small mt-1">
                                        {{ $cobro->tipo === 'pelicula' ? 'Película' : 'Producto' }}
                                    </div>
                                </div>
                            </div>
                        </div>
                        @endforeach
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@push('js')
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script src="https://cdn.jsdelivr.net/npm/moment@2.29.1/moment.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/moment@2.29.1/locale/es.js"></script>
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

<script>
// Variables globales para los gráficos
let rentalsChart, incomeDistributionChart;

// Función para mostrar notificación
function showNotification(message, type = 'success') {
    const notification = $('.alert-notification');
    notification.removeClass('alert-success alert-danger alert-warning alert-info');
    notification.addClass(`alert-${type}`);
    $('#notification-message').text(message);
    notification.fadeIn();
    
    setTimeout(() => {
        notification.fadeOut();
    }, 3000);
}

// Función para cambiar el tema
function setTheme(theme) {
    $('body').removeClass('theme-dark theme-corporate');
    if (theme !== 'default') {
        $('body').addClass(`theme-${theme}`);
    }
    localStorage.setItem('dashboardTheme', theme);
}

// Cargar tema guardado
$(document).ready(function() {
    const savedTheme = localStorage.getItem('dashboardTheme') || 'default';
    setTheme(savedTheme);
    
    // Configurar botones de tema
    $('[data-theme]').click(function() {
        const theme = $(this).data('theme');
        setTheme(theme);
        showNotification(`Tema cambiado a ${theme.charAt(0).toUpperCase() + theme.slice(1)}`, 'info');
    });
    
    // Inicializar gráficos
    initCharts();
});

// Función para inicializar gráficos
function initCharts() {
    // Datos de ejemplo para el gráfico de alquileres
   
    
    // Configuración del gráfico de alquileres
    const rentalCtx = document.getElementById('rentalsChart').getContext('2d');
    rentalsChart = new Chart(rentalCtx, {
        type: 'line',
        data: rentalData,
        options: {
            responsive: true,
            plugins: {
                legend: {
                    display: false
                },
                tooltip: {
                    callbacks: {
                        label: function(context) {
                            return 'S/. ' + context.parsed.y.toFixed(2);
                        }
                    }
                }
            },
            scales: {
                y: {
                    beginAtZero: true,
                    ticks: {
                        callback: function(value) {
                            return 'S/. ' + value;
                        }
                    }
                }
            }
        }
    });
    
    // Datos para el gráfico de distribución de ingresos
    const incomeData = {
        labels: ['Películas', 'Productos'],
        datasets: [{
            data: [{{ $ingresosDiariosPeliculas }}, {{ $ingresosDiariosProductos }}],
            backgroundColor: [
                'rgba(52, 152, 219, 0.7)',
                'rgba(46, 204, 113, 0.7)'
            ],
            borderColor: [
                'rgba(52, 152, 219, 1)',
                'rgba(46, 204, 113, 1)'
            ],
            borderWidth: 1
        }]
    };
    
    // Configuración del gráfico de distribución
    const incomeCtx = document.getElementById('incomeDistributionChart').getContext('2d');
    incomeDistributionChart = new Chart(incomeCtx, {
        type: 'doughnut',
        data: incomeData,
        options: {
            responsive: true,
            plugins: {
                legend: {
                    position: 'bottom',
                },
                tooltip: {
                    callbacks: {
                        label: function(context) {
                            const label = context.label || '';
                            const value = context.raw || 0;
                            const total = context.dataset.data.reduce((a, b) => a + b, 0);
                            const percentage = Math.round((value / total) * 100);
                            return `${label}: S/. ${value.toFixed(2)} (${percentage}%)`;
                        }
                    }
                }
            },
            cutout: '70%',
        }
    });
}

// Función para filtrar datos del gráfico
function filterChartData(days) {
    // Aquí iría la lógica para obtener datos filtrados del servidor
    // Por ahora es solo un ejemplo
    showNotification(`Mostrando datos de los últimos ${days} días`, 'info');
    
    // Simular cambio de datos
    const newData = Array.from({length: days}, () => Math.floor(Math.random() * 1000) + 500);
    const newLabels = Array.from({length: days}, (_, i) => {
        const date = new Date();
        date.setDate(date.getDate() - (days - i - 1));
        return date.toLocaleDateString('es-ES', {day: 'numeric', month: 'short'});
    });
    
    rentalsChart.data.labels = newLabels;
    rentalsChart.data.datasets[0].data = newData;
    rentalsChart.update();
    
    // En una implementación real, harías una petición AJAX para obtener los datos reales
    // $.get(`/api/rentals-data?days=${days}`, function(data) {
    //     rentalsChart.data.labels = data.labels;
    //     rentalsChart.data.datasets[0].data = data.values;
    //     rentalsChart.update();
    // });
}
</script>
@endpush