@extends('adminlte::page')

@section('title', 'Agregar Película')
<head>
    <link rel="icon" href="{{ asset('icons/pelicula.png') }}" type="image/x-icon">
    <style>
        :root {
            --verde-primario: #27ae60;
            --verde-hover: #219150;
            --verde-claro: #d5f5e3;
            --gris-borde: #e0e0e0;
            --gris-texto: #6c757d;
        }
        
        .btn-primary {
            background-color: var(--verde-primario);
            border-color: var(--verde-primario);
        }
        
        .btn-primary:hover {
            background-color: var(--verde-hover);
            border-color: var(--verde-hover);
        }
        
        .border-primary {
            border-color: var(--verde-primario) !important;
        }
        
        .text-primary {
            color: var(--verde-primario) !important;
        }
        
        .form-control:focus, .form-select:focus {
            border-color: var(--verde-primario);
            box-shadow: 0 0 0 0.25rem rgba(39, 174, 96, 0.25);
        }
        
        .card {
            border-radius: 0.5rem;
            overflow: hidden;
        }
        
        .card-header {
            background-color: var(--verde-primario);
            color: white;
        }
        
        .bg-light {
            background-color: var(--verde-claro) !important;
        }
        
        @media (max-width: 768px) {
            .card {
                width: 95% !important;
            }
            
            .btn-lg {
                padding: 0.5rem 1rem;
                font-size: 1rem;
            }
        }
    </style>
</head>

@section('content_header')
    <h1 class="text-center font-weight-bold" style="color: var(--verde-primario);">🎬 Agregar Nueva Película</h1>
@endsection

@section('content')
<div class="d-flex justify-content-center">
    <div class="card shadow-lg border-0 col-12 col-md-8 col-lg-6 col-xl-4">
        <div class="card-body p-4 rounded">
            <form action="{{ route('peliculas.store') }}" method="POST" enctype="multipart/form-data" class="p-3 border rounded bg-white shadow-sm" style="border-color: var(--gris-borde) !important;">
                @csrf
                <div class="form-group mb-3">
                    <label class="font-weight-bold">Título</label>
                    <input type="text" name="titulo" class="form-control border rounded p-2 shadow-sm" style="border-color: var(--gris-borde) !important;" required>
                </div>
                <div class="form-group mb-3">
                    <label class="font-weight-bold">Duración</label>
                    <div class="d-flex align-items-center">
                        <input type="number" name="horas" class="form-control border rounded p-2 shadow-sm" style="border-color: var(--gris-borde) !important;" placeholder="Horas" min="0" required>
                        <span class="px-2 font-weight-bold">h</span>
                        <input type="number" name="minutos" class="form-control border rounded p-2 shadow-sm ml-2" style="border-color: var(--gris-borde) !important;" placeholder="Minutos" min="0" max="59" required>
                        <span class="px-2 font-weight-bold">min</span>
                    </div>
                </div>
                <div class="form-group mb-3">
                    <label class="font-weight-bold">Formato</label>
                    <input type="text" name="formato" class="form-control border rounded p-2 shadow-sm" style="border-color: var(--gris-borde) !important;" required>
                </div>
                <div class="form-group mb-3">
                    <label class="font-weight-bold">Categoría</label>
                    <select name="categoria_id" class="form-control border rounded p-2 shadow-sm" style="border-color: var(--gris-borde) !important;" required>
                        <option value="">Selecciona una categoría</option>
                        @foreach ($categorias as $categoria)
                            <option value="{{ $categoria->id }}">{{ $categoria->nombre }}</option>
                        @endforeach
                    </select>
                </div>
                <div class="form-group mb-4">
                    <label class="font-weight-bold">Estado</label>
                    <select name="estado" class="form-control border rounded p-2 shadow-sm" style="border-color: var(--gris-borde) !important;" required>
                        <option value="disponible">Disponible</option>
                        <option value="alquilada">Alquilada</option>
                    </select>
                </div>
                <div class="d-flex justify-content-between">
                    <button type="submit" class="btn btn-lg btn-primary shadow">
                        <i class="fas fa-save"></i> Guardar
                    </button>
                    <a href="{{ route('peliculas.index') }}" class="btn btn-lg btn-secondary shadow">
                        <i class="fas fa-times"></i> Cancelar
                    </a>
                </div>
            </form>
        </div>
    </div>
</div>
@endsection