@extends('adminlte::page')
@section('title', 'Editar Producto')

<head>
    <link rel="icon" href="{{ asset('icons/producto.png') }}" type="image/x-icon">
    <!-- Bootstrap 5 CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/css/bootstrap.min.css" rel="stylesheet">
    <!-- Font Awesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        :root {
            --primary-color: #4361ee;
            --secondary-color: #3bc14a;
            --accent-color: #f72585;
            --danger-color: #e63946;
            --light-bg: #f8f9fa;
        }
        
        .dropzone {
            border: 2px dashed #ced4da;
            border-radius: 8px;
            padding: 2rem;
            text-align: center;
            cursor: pointer;
            transition: all 0.3s ease;
            background-color: #f8f9fa;
            min-height: 150px;
            display: flex;
            flex-direction: column;
            justify-content: center;
            align-items: center;
        }
        
        .dropzone:hover {
            border-color: var(--primary-color);
            background-color: rgba(67, 97, 238, 0.05);
        }
        
        .dropzone.active {
            border-color: var(--primary-color);
            background-color: rgba(67, 97, 238, 0.1);
        }
        
        .dropzone-icon {
            font-size: 2.5rem;
            color: var(--primary-color);
            margin-bottom: 1rem;
        }
        
        .img-preview {
            max-height: 200px;
            object-fit: contain;
            border-radius: 6px;
            margin: 0 auto;
            display: block;
        }
        
        .current-image-container {
            position: relative;
            border-radius: 8px;
            overflow: hidden;
            margin-bottom: 1rem;
        }
        
        .current-image-overlay {
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background: rgba(0,0,0,0.5);
            display: flex;
            justify-content: center;
            align-items: center;
            opacity: 0;
            transition: opacity 0.3s;
        }
        
        .current-image-container:hover .current-image-overlay {
            opacity: 1;
        }
        
        .btn-custom-primary {
            background-color: var(--primary-color);
            border-color: var(--primary-color);
        }
        
        .btn-custom-primary:hover {
            background-color: #3a56d4;
            border-color: #3a56d4;
        }
        
        .form-section {
            background-color: white;
            border-radius: 10px;
            padding: 2rem;
            box-shadow: 0 4px 12px rgba(0,0,0,0.05);
        }
        
        .form-label {
            font-weight: 600;
            color: #495057;
        }
    </style>
</head>

@section('content')
<div class="container py-4">
    <div class="row justify-content-center">
        <div class="col-lg-8">
            <div class="form-section">
                <h2 class="mb-4 text-center"><i class="fas fa-edit me-2"></i>Editar Producto</h2>

                @if ($errors->any())
                    <div class="alert alert-danger alert-dismissible fade show" role="alert">
                        <ul class="mb-0">
                            @foreach ($errors->all() as $error)
                                <li>{{ $error }}</li>
                            @endforeach
                        </ul>
                        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                    </div>
                @endif

                <form action="{{ route('productos.update', $producto->id) }}" method="POST" enctype="multipart/form-data">
                    @csrf
                    @method('PUT')

                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group mb-3">
                                <label for="nombre" class="form-label">Nombre del Producto:</label>
                                <input type="text" name="nombre" id="nombre" class="form-control form-control-lg" 
                                       value="{{ old('nombre', $producto->nombre) }}" required>
                            </div>

                            <div class="form-group mb-3">
                                <label for="precio" class="form-label">Precio (S/):</label>
                                <div class="input-group">
                                    <span class="input-group-text">S/</span>
                                    <input type="number" name="precio" id="precio" class="form-control form-control-lg" 
                                           step="0.01" min="0" value="{{ old('precio', $producto->precio) }}" required>
                                </div>
                            </div>

                            <div class="form-group mb-3">
                                <label for="stock" class="form-label">Stock Disponible:</label>
                                <input type="number" name="stock" id="stock" class="form-control form-control-lg" 
                                       min="0" value="{{ old('stock', $producto->stock) }}" required>
                            </div>
                        </div>

                        <div class="col-md-6">
                            <div class="form-group mb-4">
                                <label class="form-label">Imagen Actual:</label>
                                <div class="current-image-container">
                                    @if($producto->imagen)
                                        <img src="{{ asset('storage/' . $producto->imagen) }}" 
                                             alt="{{ $producto->nombre }}" 
                                             class="img-fluid img-preview">
                                        <div class="current-image-overlay">
                                            <a href="{{ asset('storage/' . $producto->imagen) }}" 
                                               target="_blank" class="btn btn-light">
                                                <i class="fas fa-expand me-1"></i> Ver Completa
                                            </a>
                                        </div>
                                    @else
                                        <div class="text-center py-4 bg-light rounded">
                                            <i class="fas fa-image fa-3x text-muted mb-2"></i>
                                            <p class="text-muted mb-0">No hay imagen actual</p>
                                        </div>
                                    @endif
                                </div>
                            </div>

                            <div class="form-group mb-3">
                                <label class="form-label">Nueva Imagen:</label>
                                <div id="dropzone" class="dropzone">
                                    <i class="fas fa-cloud-upload-alt dropzone-icon"></i>
                                    <p class="mb-1">Arrastra y suelta tu imagen aquí</p>
                                    <p class="small text-muted mb-2">o haz clic para seleccionar</p>
                                    <input type="file" name="imagen" id="imagen" class="d-none" 
                                           accept="image/jpeg, image/png, image/jpg, image/webp">
                                    <button type="button" class="btn btn-sm btn-outline-primary">
                                        <i class="fas fa-folder-open me-1"></i> Seleccionar Archivo
                                    </button>
                                </div>
                                <div id="image-preview-container" class="mt-3 text-center"></div>
                                <div class="form-text">Formatos aceptados: JPEG, PNG, JPG, WEBP (Max. 2MB)</div>
                            </div>

                            @if($producto->imagen)
                            <div class="form-group mb-3 form-check form-switch">
                                <input type="checkbox" name="eliminar_imagen" id="eliminar_imagen" 
                                       class="form-check-input" role="switch">
                                <label for="eliminar_imagen" class="form-check-label">Eliminar imagen actual</label>
                            </div>
                            @endif
                        </div>
                    </div>

                    <div class="d-flex justify-content-between mt-4 pt-3 border-top">
                        <a href="{{ route('productos.index') }}" class="btn btn-secondary btn-lg px-4">
                            <i class="fas fa-arrow-left me-2"></i> Cancelar
                        </a>
                        <button type="submit" class="btn btn-custom-primary btn-lg px-4">
                            <i class="fas fa-save me-2"></i> Actualizar Producto
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

@section('js')
<!-- Bootstrap 5 JS -->
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/js/bootstrap.bundle.min.js"></script>
<!-- Script para drag and drop y vista previa -->
<script>
document.addEventListener('DOMContentLoaded', function() {
    const dropzone = document.getElementById('dropzone');
    const fileInput = document.getElementById('imagen');
    const previewContainer = document.getElementById('image-preview-container');
    
    // Click en el dropzone
    dropzone.addEventListener('click', function() {
        fileInput.click();
    });
    
    // Drag and drop events
    ['dragenter', 'dragover', 'dragleave', 'drop'].forEach(eventName => {
        dropzone.addEventListener(eventName, preventDefaults, false);
    });
    
    function preventDefaults(e) {
        e.preventDefault();
        e.stopPropagation();
    }
    
    ['dragenter', 'dragover'].forEach(eventName => {
        dropzone.addEventListener(eventName, highlight, false);
    });
    
    ['dragleave', 'drop'].forEach(eventName => {
        dropzone.addEventListener(eventName, unhighlight, false);
    });
    
    function highlight() {
        dropzone.classList.add('active');
    }
    
    function unhighlight() {
        dropzone.classList.remove('active');
    }
    
    // Handle dropped files
    dropzone.addEventListener('drop', handleDrop, false);
    
    function handleDrop(e) {
        const dt = e.dataTransfer;
        const files = dt.files;
        
        if (files.length) {
            fileInput.files = files;
            handleFiles(files);
        }
    }
    
    // Handle selected files
    fileInput.addEventListener('change', function() {
        if (this.files.length) {
            handleFiles(this.files);
        }
    });
    
    // Process files and show preview
    function handleFiles(files) {
        const file = files[0];
        
        // Validación de tipo de archivo
        const validTypes = ['image/jpeg', 'image/png', 'image/jpg', 'image/webp'];
        if (!validTypes.includes(file.type)) {
            alert('Por favor, sube solo imágenes (JPEG, PNG, JPG, WEBP)');
            return;
        }
        
        // Validación de tamaño (2MB máximo)
        if (file.size > 2 * 1024 * 1024) {
            alert('La imagen no debe exceder los 2MB');
            return;
        }
        
        const reader = new FileReader();
        reader.onload = function(event) {
            previewContainer.innerHTML = `
                <div class="alert alert-success alert-dismissible fade show" role="alert">
                    <strong>¡Imagen lista!</strong> Vista previa de la nueva imagen.
                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
                <img src="${event.target.result}" class="img-preview my-2">
                <p class="small text-muted">${file.name} (${(file.size / 1024).toFixed(1)} KB)</p>
            `;
        };
        reader.readAsDataURL(file);
    }
    
    // Manejo del checkbox para eliminar imagen
    const eliminarCheckbox = document.getElementById('eliminar_imagen');
    if (eliminarCheckbox) {
        eliminarCheckbox.addEventListener('change', function() {
            if (this.checked) {
                fileInput.disabled = true;
                fileInput.value = '';
                previewContainer.innerHTML = `
                    <div class="alert alert-warning mt-3">
                        La imagen actual será eliminada al guardar los cambios.
                    </div>
                `;
            } else {
                fileInput.disabled = false;
                previewContainer.innerHTML = '';
            }
        });
    }
});
</script>
@endsection