@extends('adminlte::page')

@section('title', 'Gestión de Productos')

@section('head')
    <link rel="icon" href="{{ asset('icons/producto.png') }}" type="image/x-icon">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.0/font/bootstrap-icons.css">
    <link rel="stylesheet" href="https://cdn.datatables.net/1.13.6/css/dataTables.bootstrap5.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/animate.css/4.1.1/animate.min.css">
@stop

@section('content_header')
<div class="d-flex justify-content-between align-items-center">
    <h1 class="m-0 text-dark">
        <i class="fas fa-boxes text-primary mr-2"></i>Gestión de Productos
    </h1>
    <div class="d-flex align-items-center">
        <div class="dropdown mr-3">
            <button class="btn btn-outline-primary dropdown-toggle" type="button" id="dropdownMenuButton" 
                    data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                <i class="fas fa-download mr-1"></i> Exportar
            </button>
            <div class="dropdown-menu" aria-labelledby="dropdownMenuButton">
                <a class="dropdown-item" href="#" id="export-pdf"><i class="fas fa-file-pdf text-danger mr-1"></i> PDF</a>
                <a class="dropdown-item" href="#" id="export-excel"><i class="fas fa-file-excel text-success mr-1"></i> Excel</a>
                <a class="dropdown-item" href="#" id="export-csv"><i class="fas fa-file-csv text-info mr-1"></i> CSV</a>
            </div>
        </div>
        <a href="{{ route('productos.create') }}" class="btn btn-primary shadow-sm" 
           style="border-radius: 50px; padding: 8px 20px;">
            <i class="fas fa-plus mr-1"></i> Nuevo Producto
        </a>
    </div>
</div>
@stop

@section('content')
<!-- Notificaciones -->
<div class="notification-container">
    @if (session('success'))
    <div class="alert alert-success alert-dismissible fade show animate__animated animate__fadeInDown" role="alert">
        <div class="d-flex align-items-center">
            <i class="fas fa-check-circle mr-2"></i>
            <strong>{{ session('success') }}</strong>
            <button type="button" class="close ml-auto" data-dismiss="alert" aria-label="Close">
                <span aria-hidden="true">&times;</span>
            </button>
        </div>
    </div>
    @endif

    <!-- Notificación de stock bajo global -->
    @if($productos->where('stock', '<', 5)->count() > 0)
    <div class="alert alert-warning alert-dismissible fade show animate__animated animate__shakeX" role="alert">
        <div class="d-flex align-items-center">
            <i class="fas fa-exclamation-triangle mr-2"></i>
            <strong>¡Atención!</strong> Tienes {{ $productos->where('stock', '<', 5)->count() }} productos con stock bajo.
            <button type="button" class="close ml-auto" data-dismiss="alert" aria-label="Close">
                <span aria-hidden="true">&times;</span>
            </button>
        </div>
    </div>
    @endif
</div>

<!-- Filtros y Búsqueda -->
<div class="card shadow-sm mb-4">
    <div class="card-body py-3">
        <div class="row">
            <div class="col-md-3">
                <div class="form-group mb-0">
                    <label for="categoria-filter" class="small text-muted">Categoría</label>
                    
                </div>
            </div>
            <div class="col-md-3">
                <div class="form-group mb-0">
                    <label for="stock-filter" class="small text-muted">Estado Stock</label>
                    <select id="stock-filter" class="form-control form-control-sm">
                        <option value="">Todos</option>
                        <option value="bajo">Stock Bajo</option>
                        <option value="normal">Stock Normal</option>
                        <option value="agotado">Agotados</option>
                    </select>
                </div>
            </div>
            <div class="col-md-6">
                <div class="form-group mb-0">
                    <label for="search-input" class="small text-muted">Buscar Producto</label>
                    <div class="input-group">
                        <input type="text" id="search-input" class="form-control form-control-sm" placeholder="Nombre, código, descripción...">
                        <div class="input-group-append">
                            <button class="btn btn-sm btn-primary" type="button" id="search-button">
                                <i class="fas fa-search"></i>
                            </button>
                            <button class="btn btn-sm btn-outline-secondary" type="button" id="reset-filters">
                                <i class="fas fa-undo"></i>
                            </button>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Tarjeta de Resumen -->
<div class="row mb-4">
    <div class="col-md-3">
        <div class="card bg-primary text-white shadow-sm">
            <div class="card-body">
                <div class="d-flex justify-content-between align-items-center">
                    <div>
                        <h6 class="mb-0">Total Productos</h6>
                        <h3 class="mb-0">{{ $productos->total() }}</h3>
                    </div>
                    <i class="fas fa-boxes fa-2x opacity-50"></i>
                </div>
            </div>
        </div>
    </div>
   
    <div class="col-md-3">
        <div class="card bg-warning text-dark shadow-sm">
            <div class="card-body">
                <div class="d-flex justify-content-between align-items-center">
                    <div>
                        <h6 class="mb-0">Stock Bajo</h6>
                        <h3 class="mb-0">{{ $productos->where('stock', '<', 5)->count() }}</h3>
                    </div>
                    <i class="fas fa-exclamation-triangle fa-2x opacity-50"></i>
                </div>
            </div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="card bg-danger text-white shadow-sm">
            <div class="card-body">
                <div class="d-flex justify-content-between align-items-center">
                    <div>
                        <h6 class="mb-0">Agotados</h6>
                        <h3 class="mb-0">{{ $productos->where('stock', 0)->count() }}</h3>
                    </div>
                    <i class="fas fa-times-circle fa-2x opacity-50"></i>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Tabla de productos -->
<div class="card shadow-sm">
    <div class="card-body p-0">
        <div class="table-responsive">
            <table id="productos-table" class="table table-hover table-striped mb-0">
                <thead class="bg-primary text-white">
                    <tr>
                        <th width="5%">ID</th>
                        <th width="20%">Producto</th>
                        <th width="15%">Categoría</th>
                        <th width="10%">Precio</th>
                        <th width="10%">Stock</th>
                        <th width="15%">Estado</th>
                        <th width="25%">Acciones</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach ($productos as $producto)
                    <tr class="{{ $producto->stock < 5 ? 'table-warning' : '' }} {{ $producto->stock == 0 ? 'table-danger' : '' }}">
                        <td>{{ $producto->id }}</td>
                        <td>
                            <div class="d-flex align-items-center">
                                <div class="mr-3">
                                    <img src="{{ asset('storage/' . $producto->imagen) }}" alt="{{ $producto->nombre }}" 
                                         class="img-thumbnail" style="width: 50px; height: 50px; object-fit: cover;">
                                </div>
                                <div>
                                    <h6 class="mb-0">{{ $producto->nombre }}</h6>
                                    <small class="text-muted">{{ Str::limit($producto->descripcion, 30) }}</small>
                                </div>
                            </div>
                        </td>
                        <td>{{ $producto->categoria->nombre ?? 'Sin categoría' }}</td>
                        <td class="font-weight-bold">S/ {{ number_format($producto->precio, 2) }}</td>
                        <td>
                            <div class="progress" style="height: 20px;">
                                @php
                                    $porcentaje = ($producto->stock / ($producto->stock_maximo ?: 100)) * 100;
                                    $color = $porcentaje < 20 ? 'bg-danger' : ($porcentaje < 50 ? 'bg-warning' : 'bg-success');
                                @endphp
                                <div class="progress-bar {{ $color }}" role="progressbar" 
                                     style="width: {{ $porcentaje }}%;" 
                                     aria-valuenow="{{ $porcentaje }}" 
                                     aria-valuemin="0" 
                                     aria-valuemax="100">
                                    {{ $producto->stock }}
                                </div>
                            </div>
                        </td>
                        <td>
                            @if($producto->stock == 0)
                                <span class="badge badge-danger p-2"><i class="fas fa-times-circle mr-1"></i> Agotado</span>
                            @elseif($producto->stock < 5)
                                <span class="badge badge-warning p-2"><i class="fas fa-exclamation-triangle mr-1"></i> Stock Bajo</span>
                            @else
                                <span class="badge badge-success p-2"><i class="fas fa-check-circle mr-1"></i> Disponible</span>
                            @endif
                        </td>
                        <td>
                            <div class="d-flex justify-content-center">
                                <a href="{{ route('productos.show', $producto->id) }}" 
                                   class="btn btn-sm btn-info mr-2 rounded-circle shadow-sm" 
                                   data-toggle="tooltip" title="Ver Detalles">
                                    <i class="fas fa-eye"></i>
                                </a>
                                <a href="{{ route('productos.edit', $producto->id) }}" 
                                   class="btn btn-sm btn-warning mr-2 rounded-circle shadow-sm" 
                                   data-toggle="tooltip" title="Editar">
                                    <i class="fas fa-edit"></i>
                                </a>
                                <button type="button" 
                                        class="btn btn-sm btn-danger rounded-circle shadow-sm delete-button" 
                                        data-id="{{ $producto->id }}"
                                        data-toggle="tooltip" title="Eliminar">
                                    <i class="fas fa-trash-alt"></i>
                                </button>
                                <form id="delete-form-{{ $producto->id }}" 
                                      action="{{ route('productos.destroy', $producto->id) }}" 
                                      method="POST" style="display: none;">
                                    @csrf
                                    @method('DELETE')
                                </form>
                            </div>
                        </td>
                    </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
    </div>
    <div class="card-footer bg-white">
        <div class="d-flex justify-content-between align-items-center">
            <div class="small text-muted">
                Mostrando {{ $productos->firstItem() }} a {{ $productos->lastItem() }} de {{ $productos->total() }} registros
            </div>
            <div>
                {{ $productos->links('pagination::bootstrap-4') }}
            </div>
        </div>
    </div>
</div>

<!-- Modal para vista rápida -->
<div class="modal fade" id="quickViewModal" tabindex="-1" role="dialog" aria-labelledby="quickViewModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header bg-primary text-white">
                <h5 class="modal-title" id="quickViewModalLabel">Detalles del Producto</h5>
                <button type="button" class="close text-white" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body" id="quickViewContent">
                <!-- Contenido cargado por AJAX -->
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">Cerrar</button>
                <a href="#" id="editProductLink" class="btn btn-primary">
                    <i class="fas fa-edit mr-1"></i> Editar Producto
                </a>
            </div>
        </div>
    </div>
</div>
@stop

@section('footer')
<div class="text-center">
    <strong>Sistema de Inventario</strong> v1.0 &copy; {{ date('Y') }} - Todos los derechos reservados
</div>
@stop

@section('js')
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script src="https://cdn.datatables.net/1.13.6/js/jquery.dataTables.min.js"></script>
<script src="https://cdn.datatables.net/1.13.6/js/dataTables.bootstrap5.min.js"></script>
<script>
$(document).ready(function() {
    // Inicializar DataTable
    $('#productos-table').DataTable({
        responsive: true,
        language: {
            url: '//cdn.datatables.net/plug-ins/1.13.6/i18n/es-ES.json'
        },
        dom: '<"top"f>rt<"bottom"lip><"clear">',
        pageLength: 10,
        lengthMenu: [5, 10, 25, 50, 100],
        order: [[0, 'desc']]
    });

    // Inicializar tooltips
    $('[data-toggle="tooltip"]').tooltip();

    // Vista rápida del producto
    $('body').on('click', '.quick-view-btn', function(e) {
        e.preventDefault();
        var productId = $(this).data('id');
        
        $.get('/productos/' + productId + '/quick-view', function(data) {
            $('#quickViewContent').html(data);
            $('#editProductLink').attr('href', '/productos/' + productId + '/edit');
            $('#quickViewModal').modal('show');
        });
    });

    // Filtros
    $('#categoria-filter, #stock-filter').change(function() {
        var categoria = $('#categoria-filter').val();
        var stock = $('#stock-filter').val();
        
        // Aquí iría la lógica para filtrar los productos
        // Podrías hacer una petición AJAX o recargar la página con los parámetros
        console.log('Filtrar por categoría:', categoria, 'y stock:', stock);
    });

    $('#search-button').click(function() {
        var searchTerm = $('#search-input').val();
        // Lógica para buscar productos
        console.log('Buscar:', searchTerm);
    });

    $('#reset-filters').click(function() {
        $('#categoria-filter, #stock-filter').val('');
        $('#search-input').val('');
        // Lógica para resetear los filtros
    });

    // Exportar datos
    $('#export-pdf').click(function(e) {
        e.preventDefault();
        // Lógica para exportar a PDF
        Swal.fire({
            title: 'Exportar a PDF',
            text: '¿Deseas exportar la lista de productos a PDF?',
            icon: 'question',
            showCancelButton: true,
            confirmButtonText: 'Exportar',
            cancelButtonText: 'Cancelar'
        });
    });

    // Confirmación de eliminación
    $('.delete-button').click(function() {
        let id = $(this).data('id');
        Swal.fire({
            title: '¿Estás seguro?',
            text: "¡Esta acción no se puede deshacer!",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#d33',
            cancelButtonColor: '#3085d6',
            confirmButtonText: 'Sí, eliminar',
            cancelButtonText: 'Cancelar',
            showLoaderOnConfirm: true,
            preConfirm: () => {
                return new Promise((resolve) => {
                    setTimeout(() => {
                        resolve();
                    }, 1000);
                });
            }
        }).then((result) => {
            if (result.isConfirmed) {
                $('#delete-form-' + id).submit();
            }
        });
    });

    // Notificación de stock bajo
    @if($productos->where('stock', '<', 5)->count() > 0)
    const Toast = Swal.mixin({
        toast: true,
        position: 'top-end',
        showConfirmButton: false,
        timer: 5000,
        timerProgressBar: true,
        didOpen: (toast) => {
            toast.addEventListener('mouseenter', Swal.stopTimer)
            toast.addEventListener('mouseleave', Swal.resumeTimer)
        }
    });
    
    Toast.fire({
        icon: 'warning',
        title: '¡Atención!',
        html: 'Tienes <b>{{ $productos->where("stock", "<", 5)->count() }}</b> productos con stock bajo',
        footer: '<a href="/productos?stock=bajo">Ver productos</a>'
    });
    @endif
});
</script>
@endsection