@extends('adminlte::page')

@section('title', 'Nueva Sala')
<head>
    <link rel="icon" href="{{ asset('icons/sala.png') }}" type="image/x-icon">
</head>
@section('content_header')
    <h1 class="text-center text-dark font-weight-bold">🎭 Crear Nueva Sala</h1>
@endsection

@section('content')
<div class="d-flex justify-content-center">
    <div class="card shadow-lg border-0 col-12 col-md-8 col-lg-6 col-xl-4">
        <div class="card-body bg-light p-4 rounded">
            <form action="{{ route('salas.store') }}" method="POST" class="p-3 border rounded bg-white shadow-sm">
                @csrf
                <div class="form-group">
                    <label class="font-weight-bold">Nombre de la Sala</label>
                    <input type="text" name="nombre" class="form-control border border-dark rounded p-2 shadow-sm bg-white" required>
                </div>
                <div class="form-group">
                    <label class="font-weight-bold">Capacidad</label>
                    <input type="number" name="capacidad" class="form-control border border-dark rounded p-2 shadow-sm bg-white" min="1" required>
                </div>
                <div class="form-group">
    <label for="estado">Estado</label>
    <select name="estado" id="estado" class="form-control">
        <option value="disponible">Disponible</option>
        <option value="ocupada">Ocupada</option>
        <option value="mantenimiento">En Mantenimiento</option>
    </select>
</div>
                <div class="form-group">
                    <label class="font-weight-bold">Tipo de Sala</label>
                    <select name="tipo" class="form-control border border-dark rounded p-2 shadow-sm bg-white" required>
                        <option value="Normal">Normal</option>
                        <option value="VIP">VIP</option>
                    </select>
                </div>
                <div class="d-flex justify-content-between">
                    <button type="submit" class="btn btn-lg btn-success shadow">Guardar</button>
                    <a href="{{ route('salas.index') }}" class="btn btn-lg btn-secondary shadow">Cancelar</a>
                </div>
            </form>
        </div>
    </div>
</div>
@endsection
