<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Reporte de Salas de Cine</title>
    <style>
        body { 
            font-family: Arial, sans-serif; 
            font-size: 12px; 
            margin: 20px;
        }
        table { 
            width: 100%; 
            border-collapse: collapse; 
            margin-top: 20px; 
        }
        th, td { 
            border: 1px solid #333; 
            padding: 5px; 
            text-align: left; 
        }
        th { 
            background-color: #f2f2f2; 
        }
        .header {
            text-align: center;
            margin-bottom: 15px;
        }
        .title {
            font-size: 16px;
            font-weight: bold;
            margin-bottom: 5px;
        }
        .info {
            display: flex;
            justify-content: space-between;
            margin-bottom: 10px;
        }
        .footer {
            margin-top: 20px;
            text-align: center;
            font-size: 10px;
        }
    </style>
</head>
<body>
    <div class="header">
        <div class="title">REPORTE DE SALAS DE CINE</div>
        <div>Listado completo de salas disponibles</div>
    </div>
    
    <div class="info">
        <div>Fecha de generación: {{ now()->format('d/m/Y H:i') }}</div>
        <div>Total de salas: {{ count($salas) }}</div>
    </div>

    <table>
        <thead>
            <tr>
                <th>ID</th>
                <th>Nombre</th>
                <th>Capacidad</th>
                <th>Tipo</th>
                <th>Estado</th>
                <th>VIP</th>
            </tr>
        </thead>
        <tbody>
            @foreach ($salas as $sala)
                <tr>
                    <td>{{ $sala->id }}</td>
                    <td>{{ $sala->nombre }}</td>
                    <td>{{ $sala->capacidad }} personas</td>
                    <td>{{ $sala->tipo }}</td>
                    <td>{{ $sala->estado }}</td>
                    <td>{{ $sala->tipo == 'VIP' ? 'Sí' : 'No' }}</td>
                </tr>
            @endforeach
        </tbody>
    </table>

    <div class="footer">
        © {{ date('Y') }} Sistema de Gestión de Cine. Todos los derechos reservados.
    </div>
</body>
</html>