@extends('adminlte::page')

@section('title', 'Venta de Productos')

@section('content_header')
    <h1>Realizar Venta</h1>
@endsection

@section('content')
    <div class="container-fluid">
        <div class="card">
            <div class="card-header">
                <h3 class="card-title">Formulario para Registrar Venta</h3>
            </div>
            <div class="card-body">
                <form action="{{ route('ventas.store') }}" method="POST">
                    @csrf

                    <!-- Un solo select para elegir el producto -->
                    <div class="form-group">
                        <label for="producto">Selecciona un producto:</label>
                        <select id="producto-select" name="producto_id" class="form-control" required>
                            <option value="">Seleccione un producto</option>
                            @foreach($productos as $producto)
                                <option value="{{ $producto->id }}" data-precio="{{ $producto->precio }}">
                                    {{ $producto->nombre }} - ${{ $producto->precio }} - Stock: {{ $producto->stock }}
                                </option>
                            @endforeach
                        </select>
                    </div>

                    <!-- Botones de acción -->
                    <div class="form-group mt-3">
                        <button type="button" class="btn btn-primary add-producto">Agregar producto</button>
                        <button type="submit" class="btn btn-success mt-3">Vender</button>
                    </div>

                    <!-- Contenedor para las cantidades de productos -->
                    <div id="productos-container"></div>
                </form>
            </div>
        </div>
    </div>
@endsection

@section('js')
    <script>
        // Función para agregar un producto con su cantidad
        document.querySelector('.add-producto').addEventListener('click', function() {
            var contenedor = document.getElementById('productos-container');
            var select = document.getElementById('producto-select');
            var productoId = select.value;
            var productoText = select.options[select.selectedIndex].text;
            
            if (productoId) {
                var nuevoProducto = document.createElement('div');
                nuevoProducto.classList.add('producto', 'mb-3');
                nuevoProducto.innerHTML = `
                    <div class="form-group">
                        <label>Producto: ${productoText}</label>
                        <input type="hidden" name="productos[${contenedor.children.length}][id]" value="${productoId}">
                    </div>
                    <div class="form-group">
                        <label for="cantidad">Cantidad:</label>
                        <input type="number" name="productos[${contenedor.children.length}][cantidad]" class="form-control" required min="1" />
                    </div>
                `;
                contenedor.appendChild(nuevoProducto);
            } else {
                alert("Por favor, selecciona un producto.");
            }
        });
    </script>
@endsection
