<div id="imprimirContenido">
    <div class="row mb-4">
        <div class="col-md-6">
            <h4 class="font-weight-bold">Información de la Venta</h4>
            <table class="table table-sm table-borderless">
                <tr>
                    <th width="120px">ID Venta:</th>
                    <td>#{{ $venta->id }}</td>
                </tr>
                <tr>
                    <th>Fecha:</th>
                    <td>{{ $venta->created_at->format('d/m/Y H:i:s') }}</td>
                </tr>
                <tr>
                    <th>Estado:</th>
                    <td>
                        @if($venta->estado === 'pagado')
                            <span class="badge badge-success">Pagado</span>
                        @else
                            <span class="badge badge-warning">Pendiente</span>
                        @endif
                    </td>
                </tr>
            </table>
        </div>
        <div class="col-md-6 text-right">
            <h4 class="font-weight-bold">Resumen de Pago</h4>
            <table class="table table-sm table-borderless">
                <tr>
                    <th width="120px">Total:</th>
                    <td class="text-right font-weight-bold">S/ {{ number_format($venta->detalles->sum('subtotal'), 2) }}</td>
                </tr>
            </table>
        </div>
    </div>
    
    @if($venta->detalles->count())
    <div class="table-responsive">
        <table class="table table-bordered">
            <thead class="bg-light">
                <tr>
                    <th width="70%">Producto</th>
                    <th width="30%" class="text-right">P. Unitario</th>
                </tr>
            </thead>
            <tbody>
                @foreach($venta->detalles as $detalle)
                <tr>
                    <td>{{ $detalle->producto->nombre ?? 'Producto eliminado' }}</td>
                    <td class="text-right">S/ {{ number_format($detalle->precio_unitario, 2) }}</td>
                </tr>
                @endforeach
            </tbody>
        </table>
    </div>
    @else
    <div class="alert alert-warning">
        <i class="fas fa-exclamation-triangle mr-2"></i> No hay productos registrados en esta venta.
    </div>
    @endif
</div>