

<?php $__env->startSection('title', 'Lista de Películas'); ?>

<?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('crear peliculas')): ?>
<?php $__env->startSection('content_header'); ?>
<!-- Incluir SweetAlert2 desde CDN -->
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<link rel="icon" href="<?php echo e(asset('icons/pelicula.png')); ?>" type="image/x-icon">

<!-- Bootstrap 5 CSS -->
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/css/bootstrap.min.css" rel="stylesheet">
<!-- Font Awesome -->
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">

<!-- Bootstrap 5 JS -->
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/js/bootstrap.bundle.min.js"></script>

<style>
    
    .bg-gradient-primary {
        background: linear-gradient(135deg, #27ae60 0%, #2ecc71 100%) !important;
    }
    
    .btn-hover-primary:hover {
        background-color: #27ae60 !important;
        color: white !important;
        transform: translateY(-2px);
    }
    
    .btn-hover-light:hover {
        background-color: white !important;
        color: #27ae60 !important;
    }
    
    .rounded-top {
        border-radius: 0.5rem 0.5rem 0 0 !important;
    }
    
    .input-group-sm .form-control, 
    .input-group-sm .form-select {
        min-height: 32px;
    }
    
    .shadow-none {
        box-shadow: none !important;
    }

    /* Nuevos estilos para la paleta verde */
    .btn-primary {
        background-color: #27ae60;
        border-color: #27ae60;
    }
    
    .btn-primary:hover {
        background-color: #219150;
        border-color: #219150;
    }
    
    .btn-outline-primary {
        color: #27ae60;
        border-color: #27ae60;
    }
    
    .btn-outline-primary:hover {
        background-color: #27ae60;
        color: white;
    }
    
    .table-primary, .bg-primary {
        background-color: #27ae60 !important;
    }
    
    .badge.bg-success {
        background-color: #27ae60 !important;
    }
    
    .alert-success {
        background-color: #d5f5e3;
        border-color: #27ae60;
        color: #155724;
    }
    
    .border-primary {
        border-color: #27ae60 !important;
    }
    
    .text-primary {
        color: #27ae60 !important;
    }
    
    .pagination .page-item.active .page-link {
        background-color: #27ae60;
        border-color: #27ae60;
    }
    
    .pagination .page-link {
        color: #27ae60;
    }
    
    .modal-header {
        background-color: #27ae60 !important;
        color: white !important;
    }
    
    .form-control:focus, .form-select:focus {
        border-color: #27ae60;
        box-shadow: 0 0 0 0.25rem rgba(39, 174, 96, 0.25);
    }
     /* Estilos para móviles */
     @media (max-width: 767.98px) {
        .card-header {
            gap: 0.5rem;
        }
        
        .btn {
            padding: 0.375rem 0.75rem;
            font-size: 0.875rem;
        }
        
        .input-group-sm .form-control, 
        .input-group-sm .form-select {
            height: calc(1.5em + 0.5rem + 2px);
            padding: 0.25rem 0.5rem;
            font-size: 0.875rem;
        }
        
        .input-group-text {
            padding: 0.25rem 0.5rem;
        }
    }
</style>

<div class="card-header bg-gradient-primary text-white d-flex flex-column flex-md-row justify-content-between align-items-stretch align-items-md-center p-2 p-md-3 rounded-top">

    <!-- Parte izquierda: Agregar Película -->
     <!-- Parte izquierda: Agregar Película -->
     <div class="d-flex align-items-center">
        <button class="btn btn-light btn-hover-primary d-flex align-items-center fw-bold" 
                data-bs-toggle="modal" data-bs-target="#addMovieModal">
            <i class="fas fa-plus-circle me-2"></i> Nueva Película
        </button>
    </div>

    <!-- Parte central: Acciones de exportación/importación -->
    <div class="d-flex flex-wrap justify-content-center gap-1 gap-md-2 mb-2 mb-md-0">
        <!-- Botón para Excel -->
        <a href="<?php echo e(route('peliculas.export-excel')); ?>" 
           class="btn btn-success btn-hover-light d-flex align-items-center fw-bold py-2"
           title="Exportar a Excel">
            <i class="fas fa-file-excel me-0 me-md-2"></i> 
            <span class="d-none d-md-inline">Excel</span>
        </a>
        
        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('crear peliculas')): ?>
        <a href="<?php echo e(route('peliculas.export-pdf')); ?>" 
           class="btn btn-danger btn-hover-light d-flex align-items-center fw-bold py-2"
           target="_blank" title="Descargar PDF">
            <i class="fas fa-file-pdf me-0 me-md-2"></i> 
            <span class="d-none d-md-inline">PDF</span>
        </a>
        <?php endif; ?>
        
        <button type="button" 
                class="btn btn-info text-white btn-hover-light d-flex align-items-center fw-bold py-2"
                data-bs-toggle="modal" data-bs-target="#importModal">
            <i class="fas fa-file-import me-0 me-md-2"></i> 
            <span class="d-none d-md-inline">Importar</span>
        </button>
    </div>

    <!-- Parte derecha: Filtros -->
    <div class="d-flex flex-column flex-sm-row align-items-stretch align-items-sm-center gap-2">
        <!-- Filtro por Categoría -->
        <form action="<?php echo e(route('peliculas.index')); ?>" method="GET" class="d-flex align-items-center">
            <div class="input-group input-group-sm">
                <span class="input-group-text bg-white">
                    <i class="fas fa-filter text-success"></i>
                </span>
                <select name="categoria_id" id="categoria_id" 
                        class="form-select form-select-sm shadow-none" 
                        onchange="this.form.submit()">
                    <option value="">Todas</option>
                    <?php $__currentLoopData = $categorias; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $categoria): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($categoria->id); ?>" <?php echo e(request('categoria_id') == $categoria->id ? 'selected' : ''); ?>>
                            <?php echo e($categoria->nombre); ?>

                        </option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
            </div>
        </form>

        <!-- Formulario de Búsqueda -->
        <form action="<?php echo e(route('peliculas.index')); ?>" method="GET" class="d-flex align-items-center">
            <div class="input-group input-group-sm">
                <input type="text" name="search" value="<?php echo e(request()->search); ?>" 
                       class="form-control form-control-sm shadow-none" 
                       placeholder="Buscar..." 
                       aria-label="Buscar película">
                <button type="submit" class="btn btn-primary">
                    <i class="fas fa-search"></i>
                </button>
            </div>
        </form>
    </div>
</div>



<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div class="card shadow-sm">
    <div class="card-body">
        <?php if(session('success')): ?>
            <div class="alert alert-success"><?php echo e(session('success')); ?></div>
        <?php endif; ?>
        <?php if($errors->any()): ?>
            <div class="alert alert-danger">
                <ul>
                    <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <li><?php echo e($error); ?></li>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </ul>
            </div>
        <?php endif; ?>
   
        <div class="table-responsive">
            <table class="table table-hover text-center">
                <thead class="table-primary">
                    <tr>
                        <th>ID</th>
                        <th>Título</th>
                        <th>Duración</th>
                        <th>Formato</th>
                        <th>Categoría</th>
                        <th>Estado</th>
                        <th>Acciones</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__currentLoopData = $peliculas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $pelicula): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td><?php echo e($pelicula->id); ?></td>
                            <td><?php echo e($pelicula->titulo); ?></td>
                            <td><?php echo e(floor($pelicula->duracion / 60)); ?>h <?php echo e($pelicula->duracion % 60); ?>min</td>
                            <td><?php echo e($pelicula->formato); ?></td>
                            <td><?php echo e(optional($pelicula->categoria)->nombre ?? 'Sin categoría'); ?></td>
                            <td>
                                <span class="badge bg-success text-white p-2 fw-bold shadow">
                                    <?php echo e(strtoupper($pelicula->estado)); ?>

                                </span>
                            </td>
                            <td class="d-flex flex-wrap justify-content-center gap-1">
                                <a href="<?php echo e(route('peliculas.show', $pelicula)); ?>" class="btn btn-info btn-sm d-flex align-items-center">
                                    <i class="fas fa-eye"></i> Ver
                                </a>
                                <a href="<?php echo e(route('peliculas.edit', $pelicula)); ?>" class="btn btn-warning btn-sm d-flex align-items-center">
                                    <i class="fas fa-edit"></i> Editar
                                </a>
                                <form action="<?php echo e(route('peliculas.destroy', $pelicula)); ?>" method="POST" class="d-inline delete-form">
                                    <?php echo csrf_field(); ?>
                                    <?php echo method_field('DELETE'); ?>
                                    <button type="submit" class="btn btn-danger btn-sm d-flex align-items-center">
                                        <i class="fas fa-trash-alt"></i> Eliminar
                                    </button>
                                </form>
                            </td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>
        </div>
        <div class="d-flex justify-content-center">
            <ul class="pagination">
                <!-- Flecha de retroceso para ir al bloque anterior -->
                <?php if($peliculas->currentPage() > 5): ?>
                    <li class="page-item">
                        <a class="page-link" href="<?php echo e($peliculas->url($peliculas->currentPage() - 5)); ?>">&laquo;</a>
                    </li>
                <?php endif; ?>

                <!-- Mostrar los números de página en bloques de 5 -->
                <?php
                    $currentBlock = floor(($peliculas->currentPage() - 1) / 5);
                    $startPage = $currentBlock * 5 + 1;
                    $endPage = min($startPage + 4, $peliculas->lastPage());
                ?>

                <?php for($i = $startPage; $i <= $endPage; $i++): ?>
                    <li class="page-item <?php echo e($peliculas->currentPage() == $i ? 'active' : ''); ?>">
                        <a class="page-link" href="<?php echo e($peliculas->url($i)); ?>"><?php echo e($i); ?></a>
                    </li>
                <?php endfor; ?>

                <!-- Flecha de avance para ir al siguiente bloque de 5 -->
                <?php if($endPage < $peliculas->lastPage()): ?>
                    <li class="page-item">
                        <a class="page-link" href="<?php echo e($peliculas->url($endPage + 1)); ?>">&raquo;</a>
                    </li>
                <?php endif; ?>
            </ul>
        </div>
    </div>
</div>

<!-- Modal para Agregar Película - Versión Moderna -->
<div class="modal fade" id="addMovieModal" tabindex="-1" aria-labelledby="addMovieModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg modal-dialog-centered">
        <div class="modal-content border-0 shadow-lg">
            <div class="modal-header bg-gradient-primary p-4">
                <div class="d-flex align-items-center">
                    <i class="fas fa-film fs-3 text-white me-3"></i>
                    <h5 class="modal-title text-white fw-bold m-0" id="addMovieModalLabel">Agregar Nueva Película</h5>
                </div>
                <button type="button" class="btn-close btn-close-white shadow-none" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            
            <div class="modal-body p-4 p-md-5">
                <form action="<?php echo e(route('peliculas.store')); ?>" method="POST" enctype="multipart/form-data" class="needs-validation" novalidate>
                    <?php echo csrf_field(); ?>
                    
                    <!-- Título -->
                    <div class="mb-4">
                        <label for="titulo" class="form-label fw-semibold text-dark">Título <span class="text-danger">*</span></label>
                        <div class="input-group">
                            <span class="input-group-text bg-light border-end-0"><i class="fas fa-heading text-muted"></i></span>
                            <input type="text" name="titulo" id="titulo" class="form-control border-start-0 ps-2" placeholder="Ej: El Padrino" required>
                            <div class="invalid-feedback">
                                Por favor ingresa el título de la película
                            </div>
                        </div>
                    </div>

                    <!-- Duración -->
                    <div class="mb-4">
                        <label class="form-label fw-semibold text-dark">Duración <span class="text-danger">*</span></label>
                        <div class="row g-3">
                            <div class="col-md-6">
                                <div class="input-group">
                                    <span class="input-group-text bg-light"><i class="far fa-clock text-muted"></i></span>
                                    <input type="number" name="horas" class="form-control" placeholder="Horas" min="0" required>
                                    <span class="input-group-text bg-light">h</span>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="input-group">
                                    <input type="number" name="minutos" class="form-control" placeholder="Minutos" min="0" max="59" required>
                                    <span class="input-group-text bg-light">min</span>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Formato -->
                    <div class="mb-4">
                        <label for="formato" class="form-label fw-semibold text-dark">Formato <span class="text-danger">*</span></label>
                        <div class="input-group">
                            <span class="input-group-text bg-light"><i class="fas fa-compact-disc text-muted"></i></span>
                            <select name="formato" id="formato" class="form-select" required>
                                <option value="" selected disabled>Selecciona un formato</option>
                                <option value="Blu-ray">BLU-RAY</option>
                                <option value="DVD">DVD</option>
                                <option value="4K UHD">4K UHD</option>
                                
                            </select>
                        </div>
                    </div>

                    <!-- Categoría -->
                    <div class="mb-4">
                        <label for="categoria_id" class="form-label fw-semibold text-dark">Categoría <span class="text-danger">*</span></label>
                        <div class="input-group">
                            <span class="input-group-text bg-light"><i class="fas fa-tags text-muted"></i></span>
                            <select name="categoria_id" class="form-select" required>
                                <option value="" selected disabled>Selecciona una categoría</option>
                                <?php $__currentLoopData = $categorias; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $categoria): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($categoria->id); ?>"><?php echo e($categoria->nombre); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>
                    </div>

                    <!-- Estado -->
                    <div class="mb-4">
                        <label for="estado" class="form-label fw-semibold text-dark">Estado <span class="text-danger">*</span></label>
                        <div class="input-group">
                            <span class="input-group-text bg-light"><i class="fas fa-info-circle text-muted"></i></span>
                            <select name="estado" id="estado" class="form-select" required>
                                <option value="disponible" selected>Disponible</option>
                                <option value="alquilada">Alquilada</option>
                                <option value="mantenimiento">En mantenimiento</option>
                            </select>
                        </div>
                    </div>

                
                    <!-- Botones -->
                    <div class="d-flex justify-content-between pt-3">
                        <button type="button" class="btn btn-outline-secondary rounded-pill px-4" data-bs-dismiss="modal">
                            <i class="fas fa-times me-2"></i> Cancelar
                        </button>
                        <button type="submit" class="btn btn-primary rounded-pill px-4 shadow-sm">
                            <i class="fas fa-save me-2"></i> Guardar Película
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

<!-- Modal para importar Excel - Versión mejorada -->
<div class="modal fade" id="importModal" tabindex="-1" aria-labelledby="importModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content rounded-4 shadow-lg">
            <div class="modal-header bg-primary text-white">
                <h5 class="modal-title d-flex align-items-center" id="importModalLabel">
                    <i class="fas fa-file-import me-2"></i> Importar Películas desde Excel
                </h5>
                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body p-4">
                <div class="alert alert-info d-flex align-items-center">
                    <i class="fas fa-info-circle me-2 fs-4"></i>
                    <div>
                        <strong>Formato requerido:</strong> El archivo Excel debe contener columnas con los siguientes encabezados: 
                        <code>Título, Duración (minutos), Formato, Categoría, Estado</code>.
                        <a href="<?php echo e(asset('plantillas/plantilla_peliculas.xlsx')); ?>" class="alert-link d-block mt-2">
                            <i class="fas fa-download me-1"></i> Descargar plantilla de ejemplo
                        </a>
                    </div>
                </div>
                
                <form action="<?php echo e(route('peliculas.import')); ?>" method="POST" enctype="multipart/form-data" class="mt-4">
                    <?php echo csrf_field(); ?>
                    <div class="mb-4">
                        <label for="file" class="form-label fw-bold mb-3">Seleccionar archivo Excel</label>
                        <div class="input-group">
                            <input type="file" class="form-control form-control-lg border-2" id="file" name="file" required accept=".xlsx, .xls, .csv">
                            <button class="btn btn-outline-secondary" type="button" id="clearFile">
                                <i class="fas fa-times"></i>
                            </button>
                        </div>
                        <div class="form-text">Formatos admitidos: .xlsx, .xls, .csv (Tamaño máximo: 5MB)</div>
                    </div>
                    
                    <div class="d-flex justify-content-between align-items-center mt-4 pt-3 border-top">
                        <button type="button" class="btn btn-outline-secondary" data-bs-dismiss="modal">
                            <i class="fas fa-times me-2"></i> Cancelar
                        </button>
                        <button type="submit" class="btn btn-primary btn-lg">
                            <i class="fas fa-upload me-2"></i> Importar Datos
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('footer'); ?>
    <div class="text-center">
        <small>Sistema de Gestión de Películas © <?php echo e(date('Y')); ?></small>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('js'); ?>
<script>
    $('#addMovieModal').on('show.bs.modal', function (event) {
        $.ajax({
            url: '<?php echo e(route('categorias.json')); ?>',
            type: 'GET',
            success: function(response) {
                var select = $('#categoria_id');
                select.empty();
                select.append('<option value="">Selecciona una categoría</option>');
                response.forEach(function(categoria) {
                    select.append('<option value="' + categoria.id + '">' + categoria.nombre + '</option>');
                });
            },
            error: function() {
                alert('Hubo un problema al cargar las categorías.');
            }
        });
    });

    // Función para hacer la búsqueda en tiempo real
    $(document).ready(function() {
        $('#search').on('input', function() {
            var searchTerm = $(this).val();
            if (searchTerm.length >= 3) {
                $.ajax({
                    url: '<?php echo e(route('peliculas.search')); ?>',
                    type: 'GET',
                    data: { term: searchTerm },
                    success: function(response) {
                        var peliculas = response.peliculas;
                        console.log(peliculas);
                    }
                });
            }
        });
        
        // Mejorar el modal de importación
        // Limpiar selección de archivo
        $('#clearFile').click(function() {
            $('#file').val('');
        });
        
        // Validación del archivo antes de enviar
        $('form[action="<?php echo e(route('peliculas.import')); ?>"]').submit(function(e) {
            var fileInput = $('#file');
            var filePath = fileInput.val();
            var allowedExtensions = /(\.xlsx|\.xls|\.csv)$/i;
            
            if(!allowedExtensions.exec(filePath)) {
                Swal.fire({
                    title: 'Formato inválido',
                    text: 'Por favor sube un archivo con extensión .xlsx, .xls o .csv',
                    icon: 'error',
                    confirmButtonText: 'Entendido'
                });
                return false;
            }
            
            return true;
        });
    });

    // Usar SweetAlert2 para confirmar la eliminación
    document.querySelectorAll('.delete-form').forEach(form => {
        form.addEventListener('submit', function(event) {
            event.preventDefault();

            Swal.fire({
                title: '¿Estás seguro?',
                text: "¡No podrás revertir esta acción!",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#d33',
                confirmButtonText: 'Sí, eliminar!',
                cancelButtonText: 'Cancelar'
            }).then((result) => {
                if (result.isConfirmed) {
                    this.submit();
                }
            });
        });
    });
</script>
<?php $__env->stopSection(); ?>
<?php endif; ?>
<?php echo $__env->make('adminlte::page', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\cinema-laravel11\resources\views/peliculas/index.blade.php ENDPATH**/ ?>