

<?php $__env->startSection('title', 'Reporte Diario de Ventas y Alquileres'); ?>

<?php $__env->startSection('content_header'); ?>
<link href="https://cdnjs.cloudflare.com/ajax/libs/select2/4.0.13/css/select2.min.css" rel="stylesheet" />
<link href="https://cdnjs.cloudflare.com/ajax/libs/animate.css/4.1.1/animate.min.css" rel="stylesheet" />
<link href="https://cdnjs.cloudflare.com/ajax/libs/sweetalert2/11.4.8/sweetalert2.min.css" rel="stylesheet" />
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.0/font/bootstrap-icons.css">
<link rel="icon" href="<?php echo e(asset('icons/servicio.png')); ?>" type="image/x-icon">
<style>
    :root {
        --primary-color: #5e72e4;
        --primary-light: #8392f7;
        --primary-dark: #324cdd;
        --secondary-color: #2dce89;
        --secondary-light: #4debb7;
        --secondary-dark: #1aae6f;
        --gray-100: #f8f9fa;
        --gray-200: #e9ecef;
        --gray-300: #dee2e6;
        --gray-800: #343a40;
        --text-color: #525f7f;
        --title-color: #32325d;
        --box-shadow: 0 2px 5px rgba(50, 50, 93, .1), 0 1px 2px rgba(0, 0, 0, .07);
        --border-radius: 8px;
        --transition: all 0.2s ease-in-out;
    }
    
    body {
        color: var(--text-color);
    }
    
    .card {
        border: none;
        border-radius: var(--border-radius);
        box-shadow: var(--box-shadow);
        transition: var(--transition);
        overflow: hidden;
        margin-bottom: 1.5rem;
    }
    
    .card:hover {
        box-shadow: 0 4px 12px rgba(50, 50, 93, .15), 0 2px 4px rgba(0, 0, 0, .1);
    }
    
    .card-header {
        border-bottom: 1px solid var(--gray-200);
        padding: 0.75rem 1.25rem;
        font-weight: 600;
        font-size: 1rem;
    }
    
    .ventas-header {
        background: linear-gradient(87deg, var(--primary-color) 0, var(--primary-dark) 100%);
    }
    
    .alquileres-header {
        background: linear-gradient(87deg, var(--secondary-color) 0, var(--secondary-dark) 100%);
    }
    
    .table-wrapper {
        position: relative;
        border-radius: 0;
        height: 120px;
        overflow: hidden;
    }
    
    .table-container {
        height: calc(120px - 40px);
        overflow-y: auto;
    }
    
    .table-container::-webkit-scrollbar {
        width: 4px;
    }
    
    .table-container::-webkit-scrollbar-track {
        background: var(--gray-100);
    }
    
    .table-container::-webkit-scrollbar-thumb {
        background: var(--gray-300);
        border-radius: 10px;
    }
    
    .table-container::-webkit-scrollbar-thumb:hover {
        background: var(--gray-800);
    }
    
    .table-header {
        position: sticky;
        top: 0;
        z-index: 10;
        font-size: 0.75rem;
        text-transform: uppercase;
        letter-spacing: 0.5px;
    }
    
    .ventas-table .table-header {
        background-color: var(--primary-color);
        color: white;
    }
    
    .alquileres-table .table-header {
        background-color: var(--secondary-color);
        color: white;
    }
    
    .table {
        margin-bottom: 0;
        width: 100%;
        font-size: 0.875rem;
    }
    
    .table th, .table td {
        padding: 0.75rem 1rem;
        vertical-align: middle;
        text-align: center;
    }
    
    .table tbody tr {
        height: 40px;
        transition: var(--transition);
    }
    
    .table tbody tr:hover {
        background-color: rgba(0, 0, 0, 0.02);
    }
    
    .btn-export {
        border-radius: var(--border-radius);
        font-weight: 500;
        padding: 0.375rem 0.75rem;
        font-size: 0.75rem;
        box-shadow: 0 1px 3px rgba(50, 50, 93, .15), 0 1px 0 rgba(0, 0, 0, .02);
        transition: var(--transition);
        border: none;
    }
    
    .btn-export:hover {
        transform: translateY(-1px);
        box-shadow: 0 4px 6px rgba(50, 50, 93, .1), 0 1px 3px rgba(0, 0, 0, .08);
    }
    
    /* Columnas */
    .col-id { width: 8%; }
    .col-producto { width: 22%; }
    .col-cantidad { width: 12%; }
    .col-total { width: 18%; }
    .col-hora { width: 12%; }
    .col-metodo { width: 15%; }
    
    /* Filtros */
    .filters-container {
        background-color: white;
        padding: 1.5rem;
        margin-bottom: 1.5rem;
        border-radius: var(--border-radius);
        box-shadow: var(--box-shadow);
    }
    
    .filters-container h4 {
        color: var(--title-color);
        font-size: 1.2rem;
        font-weight: 600;
        margin-bottom: 1rem;
        position: relative;
        padding-bottom: 0.5rem;
    }
    
    .filters-container h4:after {
        content: '';
        position: absolute;
        bottom: 0;
        left: 0;
        width: 40px;
        height: 3px;
        background: var(--primary-color);
        border-radius: 3px;
    }
    
    .filter-card {
        position: relative;
        padding: 1rem;
        border-radius: var(--border-radius);
        background-color: var(--gray-100);
        transition: var(--transition);
        height: 100%;
    }
    
    .filter-card:hover {
        box-shadow: 0 2px 6px rgba(50, 50, 93, .1);
    }
    
    .filter-card h5 {
        font-size: 0.9rem;
        font-weight: 600;
        color: var(--title-color);
        margin-bottom: 0.75rem;
    }
    
    .input-group {
        box-shadow: 0 1px 3px rgba(50, 50, 93, .15), 0 1px 0 rgba(0, 0, 0, .02);
        border-radius: var(--border-radius);
        overflow: hidden;
    }
    
    .form-control {
        font-size: 0.875rem;
        border: none;
        height: calc(2.25rem + 2px);
    }
    
    .form-control:focus {
        box-shadow: none;
    }
    
    select.form-control {
        padding-right: 30px;
        background-image: url("data:image/svg+xml,%3Csvg xmlns='http://www.w3.org/2000/svg' width='8' height='5' viewBox='0 0 8 5'%3E%3Cpath fill='%235e72e4' d='M0 0l4 5 4-5z'/%3E%3C/svg%3E");
        background-repeat: no-repeat;
        background-position: right 10px center;
        background-size: 8px 5px;
        -webkit-appearance: none;
        -moz-appearance: none;
        appearance: none;
    }
    
    .btn-primary {
        background-color: var(--primary-color);
        border-color: var(--primary-color);
    }
    
    .btn-primary:hover, .btn-primary:focus, .btn-primary:active {
        background-color: var(--primary-dark);
        border-color: var(--primary-dark);
    }
    
    .btn-outline-secondary {
        color: var(--text-color);
        border-color: var(--gray-300);
    }
    
    .btn-outline-secondary:hover {
        background-color: var(--gray-100);
        color: var(--text-color);
        border-color: var(--gray-300);
    }
    
    .filter-badge {
        font-size: 70%;
        font-weight: 600;
        padding: 0.35em 0.6em;
        border-radius: 10px;
        letter-spacing: 0.5px;
    }
    
    .badge-efectivo { 
        background-color: rgba(45, 206, 137, 0.1); 
        color: var(--secondary-color);
    }
    
    .badge-tarjeta { 
        background-color: rgba(94, 114, 228, 0.1); 
        color: var(--primary-color);
    }
    
    .badge-transferencia { 
        background-color: rgba(17, 205, 239, 0.1); 
        color: #11cdef;
    }
    
    .badge-yape { 
        background-color: rgba(251, 99, 64, 0.1); 
        color: #fb6340;
    }
    
    .alert-info {
        background-color: rgba(17, 205, 239, 0.1);
        border-color: rgba(17, 205, 239, 0.1);
        color: #11cdef;
        border-radius: var(--border-radius);
    }
    
    .totals-bar {
        background-color: var(--gray-100);
        padding: 0.6rem 1.25rem;
        border-top: 1px solid var(--gray-200);
        font-weight: 600;
        color: var(--title-color);
    }
    
    .empty-state {
        padding: 2rem;
        text-align: center;
        color: var(--gray-800);
        opacity: 0.6;
    }
    
    .empty-state i {
        font-size: 2.5rem;
        margin-bottom: 1rem;
        opacity: 0.5;
    }
</style>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid">
    <!-- Filtros principales -->
    <div class="filters-container">
        <h4>Filtros del Reporte</h4>
        <div class="row">
            <div class="col-md-4 mb-3">
                <div class="filter-card">
                    <h5><i class="fas fa-calendar-alt mr-2"></i>Fecha</h5>
                    <form method="GET" action="<?php echo e(route('reporte.index')); ?>">
                        <div class="input-group">
                            <input type="date" name="fecha" class="form-control" value="<?php echo e(request('fecha') ?? date('Y-m-d')); ?>">
                            <div class="input-group-append">
                                <button type="submit" class="btn btn-primary">
                                    <i class="fas fa-filter"></i> Aplicar
                                </button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
            
            <div class="col-md-8 mb-3">
                <div class="filter-card">
                    <h5><i class="fas fa-credit-card mr-2"></i>Método de Pago (Alquileres)</h5>
                    <form method="GET" action="<?php echo e(route('reporte.index')); ?>">
                        <input type="hidden" name="fecha" value="<?php echo e(request('fecha')); ?>">
                        <div class="input-group">
                            <select name="metodo_pago" class="form-control">
                                <option value="">Todos los métodos</option>
                                <option value="efectivo" <?php echo e(request('metodo_pago') == 'efectivo' ? 'selected' : ''); ?>>Efectivo</option>
                                <option value="tarjeta" <?php echo e(request('metodo_pago') == 'tarjeta' ? 'selected' : ''); ?>>Tarjeta</option>
                                <option value="transferencia" <?php echo e(request('metodo_pago') == 'transferencia' ? 'selected' : ''); ?>>Transferencia</option>
                                <option value="yape" <?php echo e(request('metodo_pago') == 'yape' ? 'selected' : ''); ?>>Yape</option>
                            </select>
                            <div class="input-group-append">
                                <button type="submit" class="btn btn-primary">
                                    <i class="fas fa-filter"></i> Filtrar
                                </button>
                                <?php if(request('metodo_pago')): ?>
                                <a href="<?php echo e(route('reporte.index', ['fecha' => request('fecha')])); ?>" class="btn btn-outline-secondary">
                                    <i class="fas fa-times"></i> Limpiar
                                </a>
                                <?php endif; ?>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
        
        <?php if(request('metodo_pago')): ?>
        <div class="alert alert-info mt-2 py-2">
            <i class="fas fa-info-circle mr-1"></i> Mostrando alquileres con método de pago: 
            <strong>
                <?php if(request('metodo_pago') == 'efectivo'): ?> Efectivo
                <?php elseif(request('metodo_pago') == 'tarjeta'): ?> Tarjeta
                <?php elseif(request('metodo_pago') == 'transferencia'): ?> Transferencia
                <?php elseif(request('metodo_pago') == 'yape'): ?> Yape
                <?php endif; ?>
            </strong>
        </div>
        <?php endif; ?>
    </div>

    <div class="row">
        <!-- Ventas -->
        <div class="col-md-6">
            <div class="card">
                <div class="card-header ventas-header text-white d-flex justify-content-between align-items-center">
                    <div>
                        <i class="fas fa-shopping-cart mr-2"></i>
                        <span>Ventas del Día</span>
                    </div>
                    <?php if(isset($ventas) && $ventas->isNotEmpty()): ?>
                    <form action="<?php echo e(route('ventas.export-excel')); ?>" method="POST" class="d-inline">
                        <?php echo csrf_field(); ?>
                        <input type="hidden" name="fecha" value="<?php echo e(request('fecha')); ?>">
                        <button type="submit" class="btn btn-sm btn-light btn-export">
                            <i class="fas fa-file-excel"></i> Exportar
                        </button>
                    </form>
                    <?php endif; ?>
                </div>
                <div class="card-body p-0">
                    <?php if(isset($ventas) && $ventas->isNotEmpty()): ?>
                        <div class="table-wrapper ventas-table">
                            <table class="table">
                                <thead class="table-header">
                                    <tr>
                                        <th class="col-id">ID</th>
                                        <th class="col-producto">Producto</th>
                                        <th class="col-cantidad">Cantidad</th>
                                        <th class="col-total">Total</th>
                                        <th class="col-hora">Hora</th>
                                    </tr>
                                </thead>
                            </table>
                            <div class="table-container">
                                <table class="table">
                                    <tbody>
                                        <?php $__currentLoopData = $ventas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $venta): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <tr>
                                                <td class="col-id"><?php echo e($venta->id); ?></td>
                                                <td class="col-producto"><?php echo e(Str::limit($venta->producto->nombre ?? 'Producto eliminado', 20)); ?></td>
                                                <td class="col-cantidad"><?php echo e($venta->cantidad); ?></td>
                                                <td class="col-total">S/ <?php echo e(number_format($venta->subtotal, 2)); ?></td>
                                                <td class="col-hora"><?php echo e(\Carbon\Carbon::parse($venta->created_at)->format('H:i')); ?></td>
                                            </tr>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                        <div class="totals-bar d-flex justify-content-between align-items-center">
                            <strong>Total Ventas:</strong> 
                            <span>S/ <?php echo e(number_format($totalVendido, 2)); ?></span>
                        </div>
                    <?php else: ?>
                        <div class="empty-state">
                            <i class="fas fa-receipt"></i>
                            <p>No hay ventas registradas para esta fecha</p>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>

        <!-- Alquileres -->
        <div class="col-md-6">
            <div class="card">
                <div class="card-header alquileres-header text-white d-flex justify-content-between align-items-center">
                    <div>
                        <i class="fas fa-clock mr-2"></i>
                        <span>Alquileres del Día</span>
                    </div>
                    <?php if(isset($alquileres) && $alquileres->isNotEmpty()): ?>
                    <form action="<?php echo e(route('exportar-alquileres-excel')); ?>" method="POST" class="d-inline">
                        <?php echo csrf_field(); ?>
                        <input type="hidden" name="fecha" value="<?php echo e(request('fecha')); ?>">
                        <input type="hidden" name="metodo_pago" value="<?php echo e(request('metodo_pago')); ?>">
                        <button type="submit" class="btn btn-sm btn-light btn-export">
                            <i class="fas fa-file-excel"></i> Exportar
                        </button>
                    </form>
                    <?php endif; ?>
                </div>
                <div class="card-body p-0">
                    <?php if(isset($alquileres) && $alquileres->isNotEmpty()): ?>
                        <div class="table-wrapper alquileres-table">
                            <table class="table">
                                <thead class="table-header">
                                    <tr>
                                        <th class="col-id">ID</th>
                                        <th class="col-producto">Cliente</th>
                                        <th class="col-cantidad">Horas</th>
                                        <th class="col-total">Total</th>
                                        <th class="col-metodo">Método</th>
                                    </tr>
                                </thead>
                            </table>
                            <div class="table-container">
                                <table class="table">
                                    <tbody>
                                        <?php $__currentLoopData = $alquileres; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $alquiler): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <tr>
                                                <td class="col-id"><?php echo e($alquiler->id); ?></td>
                                                <td class="col-producto"><?php echo e(Str::limit($alquiler->cliente, 20)); ?></td>
                                                <td class="col-cantidad"><?php echo e($alquiler->horas ?? 'N/A'); ?></td>
                                                <td class="col-total">S/ <?php echo e(number_format($alquiler->precio, 2)); ?></td>
                                                <td class="col-metodo">
                                                    <?php if($alquiler->metodo_pago == 'efectivo'): ?>
                                                        <span class="badge filter-badge badge-efectivo">Efectivo</span>
                                                    <?php elseif($alquiler->metodo_pago == 'tarjeta'): ?>
                                                        <span class="badge filter-badge badge-tarjeta">Tarjeta</span>
                                                    <?php elseif($alquiler->metodo_pago == 'transferencia'): ?>
                                                        <span class="badge filter-badge badge-transferencia">Transferencia</span>
                                                    <?php elseif($alquiler->metodo_pago == 'yape'): ?>
                                                        <span class="badge filter-badge badge-yape">Yape</span>
                                                    <?php else: ?>
                                                        <span class="badge badge-secondary">N/A</span>
                                                    <?php endif; ?>
                                                </td>
                                            </tr>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                        <div class="totals-bar d-flex justify-content-between align-items-center">
                            <strong>Total Alquileres:</strong> 
                            <span>S/ <?php echo e(number_format($totalAlquileres, 2)); ?></span>
                        </div>
                    <?php else: ?>
                        <div class="empty-state">
                            <i class="fas fa-key"></i>
                            <p>No hay alquileres registrados para esta fecha</p>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('adminlte::page', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\cinema-laravel11\resources\views/reporte/index.blade.php ENDPATH**/ ?>