

<?php $__env->startSection('title', 'Editar Película'); ?>

<?php $__env->startSection('head'); ?>
    <link rel="icon" href="<?php echo e(asset('icons/pelicula.png')); ?>" type="image/x-icon">
    <!-- Bootstrap 5 CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/css/bootstrap.min.css" rel="stylesheet">
    <!-- Font Awesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <!-- Google Fonts -->
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600&display=swap" rel="stylesheet">
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content_header'); ?>
    <div class="d-flex justify-content-between align-items-center mb-4">
        <h1 class="text-primary">
            <i class="fas fa-edit me-2"></i>Editar Película: <?php echo e($pelicula->titulo); ?>

        </h1>
        <a href="<?php echo e(route('peliculas.index')); ?>" class="btn btn-outline-secondary">
            <i class="fas fa-arrow-left me-1"></i> Volver al listado
        </a>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div class="container">
    <div class="row justify-content-center">
        <div class="col-lg-8">
            <div class="card edit-movie-card border-0 shadow-lg">
                <div class="card-header bg-primary text-white py-3">
                    <h2 class="h5 mb-0">
                        <i class="fas fa-film me-2"></i>Editar Información
                    </h2>
                </div>
                
                <div class="card-body p-4">
                    <form action="<?php echo e(route('peliculas.update', $pelicula)); ?>" method="POST">
                        <?php echo csrf_field(); ?>
                        <?php echo method_field('PUT'); ?>
                        
                        <!-- Título -->
                        <div class="mb-4 form-floating">
                            <input type="text" name="titulo" id="titulo" 
                                   class="form-control shadow-sm" 
                                   value="<?php echo e($pelicula->titulo); ?>"
                                   placeholder="Título de la película"
                                   required>
                            <label for="titulo">
                                <i class="fas fa-heading me-1"></i>Título de la Película
                            </label>
                        </div>
                        
                        <!-- Duración -->
                        <div class="mb-4">
                            <label class="form-label fw-bold">
                                <i class="fas fa-clock me-1"></i>Duración (minutos)
                            </label>
                            <input type="number" name="duracion" 
                                   class="form-control shadow-sm" 
                                   value="<?php echo e($pelicula->duracion); ?>"
                                   required>
                        </div>
                        
                        <!-- Formato -->
                        <div class="mb-4 form-floating">
                            <input type="text" name="formato" id="formato" 
                                   class="form-control shadow-sm" 
                                   value="<?php echo e($pelicula->formato); ?>"
                                   placeholder="Blu-ray, DVD, etc."
                                   required>
                            <label for="formato">
                                <i class="fas fa-compact-disc me-1"></i>Formato
                            </label>
                        </div>
                        
                        <!-- Categoría -->
                        <div class="mb-4">
                            <label class="form-label fw-bold">
                                <i class="fas fa-tag me-1"></i>Categoría
                            </label>
                            <select name="categoria_id" class="form-select shadow-sm py-3" required>
                                <?php $__currentLoopData = $categorias; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $categoria): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($categoria->id); ?>" <?php echo e($categoria->id == $pelicula->categoria_id ? 'selected' : ''); ?>>
                                        <?php echo e($categoria->nombre); ?>

                                    </option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>
                        
                        <!-- Estado -->
                        <div class="mb-4">
                            <label class="form-label fw-bold">
                                <i class="fas fa-check-circle me-1"></i>Estado
                            </label>
                            <select name="estado" class="form-select shadow-sm py-3" required>
                                <option value="disponible" <?php echo e($pelicula->estado == 'disponible' ? 'selected' : ''); ?>>
                                    <i class="fas fa-check text-success me-2"></i>Disponible
                                </option>
                                <option value="alquilada" <?php echo e($pelicula->estado == 'alquilada' ? 'selected' : ''); ?>>
                                    <i class="fas fa-times text-danger me-2"></i>Alquilada
                                </option>
                            </select>
                        </div>
                        
                        <!-- Botones -->
                        <div class="d-flex justify-content-end mt-4 pt-3 border-top">
                            <a href="<?php echo e(route('peliculas.index')); ?>" class="btn btn-outline-secondary me-3">
                                <i class="fas fa-times me-1"></i>Cancelar
                            </a>
                            <button type="submit" class="btn btn-primary">
                                <i class="fas fa-save me-1"></i>Guardar Cambios
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('css'); ?>
<style>
    :root {
        --verde-primario: #27ae60;
        --verde-hover: #219150;
        --verde-claro: #d5f5e3;
        --gris-borde: #e0e0e6;
        --gris-texto: #6c757d;
    }
    
    body {
        font-family: 'Poppins', sans-serif;
        background-color: #f8f9fa;
    }
    
    .text-primary {
        color: var(--verde-primario) !important;
        font-weight: 600;
    }
    
    .edit-movie-card {
        border-radius: 12px;
        overflow: hidden;
        transition: all 0.3s ease;
    }
    
    .edit-movie-card:hover {
        box-shadow: 0 10px 25px rgba(0, 0, 0, 0.15);
    }
    
    .bg-primary {
        background-color: var(--verde-primario) !important;
    }
    
    .form-control, .form-select {
        border-radius: 8px;
        padding: 12px 15px;
        border: 1px solid var(--gris-borde);
        transition: all 0.3s ease;
    }
    
    .form-control:focus, .form-select:focus {
        border-color: var(--verde-primario);
        box-shadow: 0 0 0 0.25rem rgba(39, 174, 96, 0.25);
    }
    
    .form-floating label {
        color: var(--gris-texto);
        padding: 0.5rem 1rem;
    }
    
    .form-floating>.form-control:focus~label {
        color: var(--verde-primario);
    }
    
    .btn {
        border-radius: 8px;
        padding: 10px 20px;
        font-weight: 500;
        transition: all 0.3s ease;
    }
    
    .btn-primary {
        background-color: var(--verde-primario);
        border-color: var(--verde-primario);
    }
    
    .btn-primary:hover {
        background-color: var(--verde-hover);
        border-color: var(--verde-hover);
        transform: translateY(-2px);
    }
    
    .btn-outline-secondary:hover {
        transform: translateY(-2px);
    }
    
    .shadow-sm {
        box-shadow: 0 2px 8px rgba(0, 0, 0, 0.05) !important;
    }
    
    .text-success {
        color: var(--verde-primario) !important;
    }
    
    .border-top {
        border-top: 1px solid var(--gris-borde) !important;
    }
</style>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('js'); ?>
<!-- Bootstrap 5 JS -->
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/js/bootstrap.bundle.min.js"></script>
<!-- SweetAlert2 -->
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

<script>
    // Si necesitas funcionalidad JavaScript adicional
    document.addEventListener('DOMContentLoaded', function() {
        // Puedes agregar scripts aquí si los necesitas
    });
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('adminlte::page', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\cinema-laravel11\resources\views/peliculas/edit.blade.php ENDPATH**/ ?>