<?php $__env->startSection('title', 'Cinestacion - Dashboard'); ?>

<head>
    <link rel="icon" href="<?php echo e(asset('imagenes/icon.png')); ?>" type="image/x-icon">
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="<?php echo e(asset('css/dashboard.css')); ?>">
   
</head>

<?php $__env->startSection('content_header'); ?>
    <?php if($alertaSalas): ?>
    <div class="alert alert-custom py-3 text-center">
        <div class="d-flex align-items-center justify-content-center">
            <i class="fas fa-exclamation-triangle fa-lg mr-3" style="color: #dc3545;"></i>
            <span style="font-weight: 500; color: #2b2d42;">¡Atención! Solo quedan <span style="font-weight: 700; color: #dc3545;"><?php echo e($salasDisponibles); ?></span> salas disponibles</span>
        </div>
    </div>
    <?php endif; ?>
    
    
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid">
    <!-- Métricas Principales -->
    <div class="row mb-4">
        <!-- Películas Disponibles -->
        <div class="col-lg-3 col-md-6 col-12 mb-4">
            <div class="metric-card h-100">
                <div class="card-body">
                    <div class="d-flex justify-content-between">
                        <div>
                            <div class="metric-icon" style="background: rgba(61, 90, 241, 0.1)">
                                <i class="fas fa-film" style="color: #3d5af1; font-size: 24px;"></i>
                            </div>
                            <h2 class="metric-value"><?php echo e($totalPeliculas); ?></h2>
                            <p class="metric-label">Películas Disponibles</p>
                        </div>
                        <div class="align-self-center">
                            <div class="progress-circle" style="width: 60px; height: 60px; position: relative;">
                                <svg width="60" height="60" viewBox="0 0 60 60">
                                    <circle cx="30" cy="30" r="25" fill="none" stroke="#f1f1f1" stroke-width="5"/>
                                    <circle cx="30" cy="30" r="25" fill="none" stroke="#3d5af1" stroke-width="5" 
                                            stroke-dasharray="157" stroke-dashoffset="<?php echo e(157 - (157 * ($totalPeliculas / max(100, $totalPeliculas)))); ?>" 
                                            transform="rotate(-90 30 30)"/>
                                </svg>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Alquileres Activos -->
        <div class="col-lg-3 col-md-6 col-12 mb-4">
            <div class="metric-card h-100" onclick="window.location='<?php echo e(route('alquileres.index')); ?>'" style="cursor: pointer;">
                <div class="card-body">
                    <div class="d-flex justify-content-between">
                        <div>
                            <div class="metric-icon" style="background: rgba(68, 160, 227, 0.1)">
                                <i class="fas fa-handshake" style="color: #44a0e3; font-size: 24px;"></i>
                            </div>
                            <h2 class="metric-value"><?php echo e($totalAlquileres); ?></h2>
                            <p class="metric-label">Alquileres Activos</p>
                        </div>
                        <div class="align-self-center">
                            <div class="progress-circle" style="width: 60px; height: 60px; position: relative;">
                                <svg width="60" height="60" viewBox="0 0 60 60">
                                    <circle cx="30" cy="30" r="25" fill="none" stroke="#f1f1f1" stroke-width="5"/>
                                    <circle cx="30" cy="30" r="25" fill="none" stroke="#44a0e3" stroke-width="5" 
                                            stroke-dasharray="157" stroke-dashoffset="<?php echo e(157 - (157 * ($totalAlquileres / max(100, $totalAlquileres)))); ?>" 
                                            transform="rotate(-90 30 30)"/>
                                </svg>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Salas Disponibles -->
        <div class="col-lg-3 col-md-6 col-12 mb-4">
            <div class="metric-card h-100">
                <div class="card-body">
                    <div class="d-flex justify-content-between">
                        <div>
                            <div class="metric-icon" style="background: rgba(255, 159, 67, 0.1)">
                                <i class="fas fa-door-open" style="color: #ff9f43; font-size: 24px;"></i>
                            </div>
                            <h2 class="metric-value"><?php echo e($salasDisponibles); ?></h2>
                            <p class="metric-label">Salas Disponibles</p>
                        </div>
                        <div class="align-self-center">
                            <div class="progress-circle" style="width: 60px; height: 60px; position: relative;">
                                <svg width="60" height="60" viewBox="0 0 60 60">
                                    <circle cx="30" cy="30" r="25" fill="none" stroke="#f1f1f1" stroke-width="5"/>
                                    <circle cx="30" cy="30" r="25" fill="none" stroke="#ff9f43" stroke-width="5" 
                                            stroke-dasharray="157" stroke-dashoffset="<?php echo e(157 - (157 * ($salasDisponibles / max(20, $salasDisponibles)))); ?>" 
                                            transform="rotate(-90 30 30)"/>
                                </svg>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Total Ingresos -->
        <div class="col-lg-3 col-md-6 col-12 mb-4">
            <div class="metric-card h-100">
                <div class="card-body">
                    <div class="d-flex justify-content-between">
                        <div>
                            <div class="metric-icon" style="background: rgba(46, 202, 106, 0.1)">
                                <i class="fas fa-calendar-day" style="color: #2eca6a; font-size: 24px;"></i>
                            </div>
                            <h2 class="metric-value">S/. <?php echo e(number_format($ingresosTotalesHoy, 2)); ?></h2>
                            <p class="metric-label">Ingresos del Día</p>
                        </div>
                        <div class="align-self-center">
                            <div class="chart-spark" style="width: 80px; height: 40px;">
                                <!-- Aquí podría ir un pequeño sparkline chart -->
                                <svg width="80" height="40" viewBox="0 0 80 40">
                                    <polyline points="0,35 10,25 20,30 30,20 40,15 50,25 60,5 70,15 80,10" 
                                              fill="none" stroke="#2eca6a" stroke-width="2"/>
                                </svg>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Desglose de Ingresos -->
    <div class="row mb-4">
        <!-- Ingresos Diarios por Películas -->
        <div class="col-md-4 col-12 mb-4">
            <div class="metric-card h-100">
                <div class="card-body">
                    <div class="d-flex align-items-center mb-3">
                        <div class="metric-icon" style="width: 45px; height: 45px; background: rgba(124, 105, 239, 0.1); margin-bottom: 0; margin-right: 15px;">
                            <i class="fas fa-video" style="color: #7c69ef; font-size: 18px;"></i>
                        </div>
                        <div>
                            <p class="metric-label mb-0">Ingresos Diarios (Películas)</p>
                            <h3 class="metric-value" style="font-size: 1.5rem;">S/. <?php echo e(number_format($ingresosDiariosPeliculas, 2)); ?></h3>
                        </div>
                    </div>
                    <div class="progress mb-2">
                        <div class="progress-bar" role="progressbar" 
                             style="width: <?php echo e(($ingresosDiariosPeliculas / max(1, $ingresosTotalesHoy)) * 100); ?>%; background: linear-gradient(45deg, #7c69ef, #a56af4);" 
                             aria-valuenow="<?php echo e($ingresosDiariosPeliculas); ?>" aria-valuemin="0" aria-valuemax="<?php echo e($ingresosTotalesHoy); ?>"></div>
                    </div>
                    <small class="text-muted"><?php echo e(round(($ingresosDiariosPeliculas / max(1, $ingresosTotalesHoy)) * 100)); ?>% del total de ingresos</small>
                </div>
            </div>
        </div>

        <!-- Ingresos Diarios por Productos -->
        <div class="col-md-4 col-12 mb-4">
    <div class="metric-card h-100">
        <div class="card-body">
            <div class="d-flex align-items-center mb-3">
                <div class="metric-icon" style="width: 45px; height: 45px; background: rgba(255, 159, 67, 0.1); margin-bottom: 0; margin-right: 15px;">
                    <i class="fas fa-box-open" style="color: #ff9f43; font-size: 18px;"></i>
                </div>
                <div>
                    <p class="metric-label mb-0">Ingresos Diarios (Productos)</p>
                    <h3 class="metric-value" style="font-size: 1.5rem;">S/. <?php echo e(number_format($ingresosDiariosProductos, 2)); ?></h3>
                </div>
            </div>
            <div class="progress mb-2">
                <div class="progress-bar" role="progressbar" 
                     style="width: <?php echo e(($ingresosDiariosProductos / max(1, $ingresosTotalesHoy)) * 100); ?>%; background: linear-gradient(45deg, #ff9f43, #ffb976);" 
                     aria-valuenow="<?php echo e($ingresosDiariosProductos); ?>" aria-valuemin="0" aria-valuemax="<?php echo e($ingresosTotalesHoy); ?>"></div>
            </div>
            <small class="text-muted"><?php echo e(round(($ingresosDiariosProductos / max(1, $ingresosTotalesHoy)) * 100)); ?>% del total de ingresos</small>
        </div>
    </div>
</div>

        <!-- Generar Reporte -->
        <div class="col-md-4 col-12 mb-4">
            <div class="metric-card h-100" onclick="window.location='<?php echo e(route('reporte.index')); ?>'" style="cursor: pointer;">
                <div class="card-body">
                    <div class="d-flex align-items-center mb-3">
                        <div class="metric-icon" style="width: 45px; height: 45px; background: rgba(46, 202, 106, 0.1); margin-bottom: 0; margin-right: 15px;">
                            <i class="fas fa-file-pdf" style="color: #2eca6a; font-size: 18px;"></i>
                        </div>
                        <div>
                            <p class="metric-label mb-0">Generación de Reportes</p>
                            <h3 class="metric-value" style="font-size: 1.5rem;">Exportar Datos</h3>
                        </div>
                    </div>
                    <div class="d-flex justify-content-between align-items-center mt-3">
                        <button class="btn btn-sm" style="background: linear-gradient(45deg, #2eca6a, #4ae68a); color: white; border-radius: 8px; padding: 8px 15px;">
                            <i class="fas fa-chart-bar mr-2"></i> Generar Reporte
                        </button>
                        <i class="fas fa-arrow-right" style="color: #2eca6a;"></i>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Filtro de Fechas -->
    <div class="row mb-4">
        <div class="col-12">
            <div class="filter-form">
                <form id="filterForm" class="d-flex flex-wrap align-items-center">
                    <div class="d-flex align-items-center mr-3">
                        <label for="startDate" class="mb-0 mr-2" style="font-size: 0.9rem; color: #6c757d;">Desde:</label>
                        <input type="date" id="startDate" class="filter-input" style="width: 150px;">
                    </div>
                    <div class="d-flex align-items-center mr-3">
                        <label for="endDate" class="mb-0 mr-2" style="font-size: 0.9rem; color: #6c757d;">Hasta:</label>
                        <input type="date" id="endDate" class="filter-input" style="width: 150px;">
                    </div>
                    <button type="button" class="filter-btn" style="background: linear-gradient(45deg, #3d5af1, #44a0e3); color: white; border: none;">
                        <i class="fas fa-filter mr-2"></i>Aplicar Filtro
                    </button>
                </form>
            </div>
        </div>
    </div>

    <!-- Gráficos -->
    <div class="row mb-4">
        <!-- Ingresos Diarios (Alquiler) -->
        <div class="col-lg-6 col-md-12 mb-4">
            <div class="chart-container h-100">
                <div class="chart-header">
                    <h3 class="chart-title">
                        <i class="fas fa-chart-bar mr-2" style="color: #3d5af1;"></i>
                        Ingresos Diarios (Precio de Alquiler)
                    </h3>
                    <div class="btn-group">
                        <button type="button" class="btn btn-sm" style="background-color: #f8f9fa; color: #6c757d; border-radius: 6px;">
                            <i class="fas fa-expand-alt"></i>
                        </button>
                    </div>
                </div>
                <canvas id="simulatedChart" style="max-height: 300px; width: 100%;"></canvas>
            </div>
        </div>

        <!-- Ingresos Diarios (Productos) -->
        <div class="col-lg-6 col-md-12 mb-4">
            <div class="chart-container h-100">
                <div class="chart-header">
                    <h3 class="chart-title">
                        <i class="fas fa-chart-line mr-2" style="color: #44a0e3;"></i>
                        Ingresos total por productos diario
                    </h3>
                    <div class="btn-group">
                        <button type="button" class="btn btn-sm" style="background-color: #f8f9fa; color: #6c757d; border-radius: 6px;">
                            <i class="fas fa-expand-alt"></i>
                        </button>
                    </div>
                </div>
                <canvas id="ingresosDiariosChart" style="max-height: 300px; width: 100%;"></canvas>
            </div>
        </div>
    </div>

    <!-- Tablas Informativas -->
    <div class="row">
        <!-- Películas Más Rentadas -->
        <div class="col-lg-6 col-md-12 mb-4">
            <div class="chart-container h-100">
                <div class="chart-header">
                    <h3 class="chart-title">
                        <i class="fas fa-trophy mr-2" style="color: #ff9f43;"></i>
                        Películas Más Rentadas
                    </h3>
                </div>
                <div class="table-responsive">
                    <table class="table table-custom">
                        <thead>
                            <tr>
                                <th>Película</th>
                                <th style="width: 50%;">Popularidad</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php
                                $maxAlquileres = $topPeliculas->max('total') ?? 1;
                                $gradientes = [
                                    'linear-gradient(45deg, #3d5af1, #44a0e3)',
                                    'linear-gradient(45deg, #7c69ef, #a56af4)',
                                    'linear-gradient(45deg, #ff9f43, #ffb976)',
                                    'linear-gradient(45deg, #2eca6a, #4ae68a)',
                                    'linear-gradient(45deg, #ea5455, #feb692)'
                                ];
                            ?>
                            <?php $__currentLoopData = $topPeliculas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $pelicula): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php
                                    $porcentaje = ($pelicula->total / $maxAlquileres) * 100;
                                    $gradiente = $gradientes[$index % count($gradientes)];
                                ?>
                                <tr>
                                    <td>
                                        <div class="d-flex align-items-center">
                                            <div style="width: 30px; height: 30px; border-radius: 6px; background: <?php echo e($gradiente); ?>; display: flex; align-items: center; justify-content: center; margin-right: 10px;">
                                                <span style="color: white; font-weight: 600;"><?php echo e($index + 1); ?></span>
                                            </div>
                                            <span style="font-weight: 500;"><?php echo e($pelicula->nombre); ?></span>
                                        </div>
                                    </td>
                                    <td>
                                        <div class="d-flex align-items-center">
                                            <div class="progress flex-grow-1 mr-3" style="height: 8px;">
                                                <div class="progress-bar" role="progressbar"
                                                    style="width: <?php echo e($porcentaje); ?>%; background: <?php echo e($gradiente); ?>;"
                                                    aria-valuenow="<?php echo e($pelicula->total); ?>" aria-valuemin="0" aria-valuemax="<?php echo e($maxAlquileres); ?>">
                                                </div>
                                            </div>
                                            <span style="font-weight: 600; min-width: 30px; text-align: right;"><?php echo e($pelicula->total); ?></span>
                                        </div>
                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>

        <div class="col-lg-6 col-md-12 mb-4">
    <div class="chart-container h-100">
        <div class="chart-header mb-3">
            <h3 class="chart-title d-flex align-items-center">
                <i class="fas fa-money-bill-wave mr-2" style="color: #2eca6a;"></i>
                Últimos Pagos Recibidos
            </h3>
        </div>

        <div class="table-responsive" style="max-height: 350px; overflow-y: auto;">
            <table class="table table-custom">
                <thead>
                    <tr>
                        <th>Película</th>
                        <th>Monto</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__empty_1 = true; $__currentLoopData = $ultimosCobros; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cobro): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <tr>
                            <td>
                                <strong><?php echo e($cobro->titulo); ?></strong><br>
                                <small class="text-muted">
                                    <i class="far fa-calendar-alt mr-1"></i>
                                    <?php echo e(\Carbon\Carbon::parse($cobro->fecha_cobro)->format('d/m/Y h:i A')); ?>

                                </small>
                            </td>
                            <td class="text-success font-weight-bold">
                                S/. <?php echo e(number_format($cobro->precio, 2)); ?>

                            </td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <tr>
                            <td colspan="2" class="text-center text-muted py-3">
                                <i class="fas fa-info-circle mr-1"></i> No se han registrado pagos recientemente.
                            </td>
                        </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>
</div>

    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('js'); ?>
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script src="https://cdn.jsdelivr.net/npm/moment@2.29.1/moment.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/moment@2.29.1/locale/es.js"></script>
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script>
     // Variable global para guardar el gráfico
 var chartInstance;
 var chartIngresosDiarios;
 
 document.addEventListener("DOMContentLoaded", function () {
     // Establecer fechas por defecto (últimos 7 días)
     const fechaInicio = '<?php echo e($startDate); ?>';
     const fechaFin = '<?php echo e($endDate); ?>';
     document.getElementById('startDate').value = fechaInicio;
     document.getElementById('endDate').value = fechaFin;
 
     // Llamar la función de actualización del gráfico con las fechas iniciales
     updateChart(fechaInicio, fechaFin);
     
     // Inicializar segundo gráfico para productos
     inicializarGraficoProductos();
 });
 
 // Función para actualizar el gráfico
 function updateChart(fechaInicio, fechaFin) {
     // Obtener el contexto del canvas
     var ctx = document.getElementById('simulatedChart').getContext('2d');
 
     // Si existe un gráfico previo, destruirlo
     if (chartInstance) {
         chartInstance.destroy();
     }
 
     // Enviar las fechas al servidor para obtener los datos filtrados
     fetch(`/dashboard/ingresos-diarios?startDate=${fechaInicio}&endDate=${fechaFin}`)
         .then(response => response.json())
         .then(data => {
             // Verificar si los datos llegan correctamente
             console.log("Datos recibidos:", data);
 
             // Extraer las fechas y montos
             var fechas = data.fechas;
             var montos = data.montos;
 
             // Si no hay datos, salir de la función
             if (fechas.length === 0 || montos.length === 0) {
                 return;
             }
 
             // Invertir las fechas y montos (más reciente a la izquierda)
             var fechasInversas = fechas.reverse();
             var montosInversos = montos.reverse();
 
             // Formatear las fechas
             var fechasFormateadas = fechasInversas.map(fecha => {
                 return moment(fecha).format('DD MMM');
             });
 
             // Crear gradiente para el fondo del gráfico
             var gradientFill = ctx.createLinearGradient(0, 0, 0, 300);
             gradientFill.addColorStop(0, 'rgba(61, 90, 241, 0.3)');
             gradientFill.addColorStop(1, 'rgba(61, 90, 241, 0)');
 
             // Crear el gráfico con los nuevos datos
             chartInstance = new Chart(ctx, {
                 type: 'bar',
                 data: {
                     labels: fechasFormateadas,
                     datasets: [{
                         label: 'Ingresos Diarios',
                         data: montosInversos,
                         backgroundColor: gradientFill,
                         borderWidth: 2,
                         borderColor: '#3d5af1',
                         borderRadius: 5,
                         barThickness: 20,
                         maxBarThickness: 30,
                     }]
                 },
                 options: {
                     responsive: true,
                     maintainAspectRatio: false,
                     plugins: {
                         legend: {
                             display: false
                         },
                         tooltip: {
                             enabled: true,
                             mode: 'index',
                             intersect: false,
                             backgroundColor: 'rgba(43, 45, 66, 0.9)',
                             titleColor: '#fff',
                             bodyColor: '#fff',
                             titleFont: {
                                 size: 13,
                                 family: 'Poppins',
                                 weight: '600'
                             },
                             bodyFont: {
                                 family: 'Poppins',
                                 size: 12
                             },
                             padding: 12,
                             cornerRadius: 8,
                             displayColors: false,
                             callbacks: {
                                 label: function(tooltipItem) {
                                     return 'S/. ' + tooltipItem.parsed.y.toFixed(2);
                                 },
                                 title: function(tooltipItems) {
                                     return moment(fechasInversas[tooltipItems[0].dataIndex]).format('dddd, DD MMM YYYY');
                                 }
                             }
                         }
                     },
                     scales: {
                         x: {
                             grid: {
                                 display: false,
                                 drawBorder: false
                             },
                             ticks: {
                                 font: {
                                     family: 'Poppins',
                                     size: 11
                                 },
                                 color: '#6c757d'
                             }
                         },
                         y: {
                             grid: {
                                 color: '#f1f1f1',
                                 drawBorder: false
                             },
                             ticks: {
                                 font: {
                                     family: 'Poppins',
                                     size: 11
                                 },
                                 color: '#6c757d',
                                 callback: function(value) {
                                     return 'S/. ' + value;
                                 }
                             },
                             beginAtZero: true
                         }
                     }
                 }
             });
         })
         .catch(error => {
             console.error("Error al obtener los datos:", error);
         });
 }
 
 // Función para inicializar el gráfico de productos
 function inicializarGraficoProductos() {
     var ctx = document.getElementById('ingresosDiariosChart').getContext('2d');
     
     // Crear datos simulados para el gráfico
     const labels = ['Lun', 'Mar', 'Mié', 'Jue', 'Vie', 'Sáb', 'Dom'];
     
     // Crear gradiente para el fondo
     var gradient = ctx.createLinearGradient(0, 0, 0, 300);
     gradient.addColorStop(0, 'rgba(255, 159, 67, 0.3)');
     gradient.addColorStop(1, 'rgba(255, 159, 67, 0)');
     
     const data = {
         labels: labels,
         datasets: [{
             label: 'Ingresos por Productos',
             data: [<?php echo e($ingresosDiariosProductos * 0.85); ?>, <?php echo e($ingresosDiariosProductos * 0.75); ?>, 
                    <?php echo e($ingresosDiariosProductos * 0.9); ?>, <?php echo e($ingresosDiariosProductos * 1.1); ?>, 
                    <?php echo e($ingresosDiariosProductos * 1.25); ?>, <?php echo e($ingresosDiariosProductos * 1.5); ?>, 
                    <?php echo e($ingresosDiariosProductos * 1.2); ?>],
             fill: true,
             backgroundColor: gradient,
             borderColor: '#ff9f43',
             tension: 0.4,
             pointBackgroundColor: '#ff9f43',
             pointBorderColor: '#fff',
             pointBorderWidth: 2,
             pointRadius: 4,
             pointHoverRadius: 6
         }]
     };
 
     // Crear el gráfico
     chartIngresosDiarios = new Chart(ctx, {
         type: 'line',
         data: data,
         options: {
             responsive: true,
             maintainAspectRatio: false,
             plugins: {
                 legend: {
                     display: false
                 },
                 tooltip: {
                     backgroundColor: 'rgba(43, 45, 66, 0.9)',
                     titleColor: '#fff',
                     bodyColor: '#fff',
                     titleFont: {
                         size: 13,
                         family: 'Poppins',
                         weight: '600'
                     },
                     bodyFont: {
                         family: 'Poppins',
                         size: 12
                     },
                     padding: 12,
                     cornerRadius: 8,
                     displayColors: false,
                     callbacks: {
                         label: function(context) {
                             return 'S/. ' + context.parsed.y.toFixed(2);
                         }
                     }
                 }
             },
             scales: {
                 x: {
                     grid: {
                         display: false,
                         drawBorder: false
                     },
                     ticks: {
                         font: {
                             family: 'Poppins',
                             size: 11
                         },
                         color: '#6c757d'
                     }
                 },
                 y: {
                     grid: {
                         color: '#f1f1f1',
                         drawBorder: false
                     },
                     ticks: {
                         font: {
                             family: 'Poppins',
                             size: 11
                         },
                         color: '#6c757d',
                         callback: function(value) {
                             return 'S/. ' + value;
                         }
                     },
                     beginAtZero: true
                 }
             }
         }
     });
 }
 
 // Manejador de eventos para el botón de filtrar - CORREGIDO
 document.querySelector(".filter-btn").addEventListener("click", function() {
     const startDate = document.getElementById('startDate').value;
     const endDate = document.getElementById('endDate').value;
     
     // Validar fechas
     if (!startDate || !endDate) {
         Swal.fire({
             title: 'Atención',
             text: 'Por favor seleccione ambas fechas para filtrar',
             icon: 'warning',
             confirmButtonColor: '#3d5af1'
         });
         return;
     }
     
     // Animación de carga
     const chartContainer = document.querySelector('.chart-container');
     chartContainer.style.opacity = '0.6';
     chartContainer.style.transition = 'opacity 0.3s';
     
     // Llamar a updateChart con los valores correctos
     updateChart(startDate, endDate);
     
     // Restaurar opacidad
     setTimeout(() => {
         chartContainer.style.opacity = '1';
     }, 1000);
 });
 
 // Añadir efectos de animación a las cards de métricas
 document.querySelectorAll('.metric-card').forEach(card => {
     card.addEventListener('mouseenter', function() {
         this.style.transform = 'translateY(-5px)';
         this.style.boxShadow = '0 15px 20px rgba(0, 0, 0, 0.1)';
     });
     
     card.addEventListener('mouseleave', function() {
         this.style.transform = 'translateY(0)';
         this.style.boxShadow = '0 8px 15px rgba(0, 0, 0, 0.05)';
     });
 });
 
 // Inicializar tooltips
 if (typeof $ !== 'undefined') {
     $(function () {
         $('[data-toggle="tooltip"]').tooltip();
     });
 }
</script>
   

<?php $__env->stopPush(); ?>
<?php echo $__env->make('adminlte::page', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\cinema-laravel11\resources\views/dashboard.blade.php ENDPATH**/ ?>