@inject('layoutHelper', 'JeroenNoten\LaravelAdminLte\Helpers\LayoutHelper')

@php( $dashboard_url = View::getSection('dashboard_url') ?? config('adminlte.dashboard_url', 'home') )

@if (config('adminlte.use_route_url', false))
    @php( $dashboard_url = $dashboard_url ? route($dashboard_url) : '' )
@else
    @php( $dashboard_url = $dashboard_url ? url($dashboard_url) : '' )
@endif

<a href="{{ $dashboard_url }}"
    class="{{ $layoutHelper->isLayoutTopnavEnabled() ? 'navbar-brand' : 'brand-link' }} d-flex align-items-center {{ config('adminlte.classes_brand') }}"
    style="padding: 0.5rem 1rem;">

    <div class="d-flex align-items-center">
        {{-- Small brand logo --}}
        <img src="{{ asset(config('adminlte.logo_img', 'vendor/adminlte/dist/img/AdminLTELogo.png')) }}"
             alt="{{ config('adminlte.logo_img_alt', 'AdminLTE') }}"
             class="{{ config('adminlte.logo_img_class', 'brand-image-xl') }}"
             style="max-height: 40px; object-fit: contain; display: {{ config('adminlte.logo_img_xl') ? 'none' : 'inline' }};">

        {{-- Large brand logo --}}
        @if(config('adminlte.logo_img_xl'))
            <img src="{{ asset(config('adminlte.logo_img_xl')) }}"
                 alt="{{ config('adminlte.logo_img_alt', 'AdminLTE') }}"
                 class="{{ config('adminlte.logo_img_xl_class', 'brand-image-xs') }}"
                 style="max-height: 40px; object-fit: contain;">
        @endif
    </div>
</a>
